% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alKDEboot.R
\name{alKDEboot}
\alias{alKDEboot}
\alias{alKDEboot.default}
\alias{print.alKDEboot}
\alias{summary.alKDEboot}
\alias{print.summary.alKDEboot}
\alias{alKDEboot.formula}
\alias{predict.alKDEboot}
\title{Arc length matching for kernel density estimators.}
\usage{
alKDEboot(formula, data = list(), xin, q1, q2, type, bootstraps, bootName,
  ...)

\method{alKDEboot}{default}(formula, data = list(), xin, q1, q2, type,
  bootstraps, bootName, ...)

\method{print}{alKDEboot}(x, ...)

\method{summary}{alKDEboot}(object, ...)

\method{print}{summary.alKDEboot}(x, ...)

\method{alKDEboot}{formula}(formula, data = list(), xin, q1, q2, type,
  bootstraps, bootName, ...)

\method{predict}{alKDEboot}(object, newdata = NULL, ...)
}
\arguments{
\item{formula}{An LHS ~ RHS formula, specifying the linear model to be estimated.}

\item{data}{A data.frame which contains the variables in \code{formula}.}

\item{xin}{Numeric vector of length equal to the number of independent variables, of initial values, for the parameters to be estimated.}

\item{q1, q2}{Numeric vectors, for the lower and upper bounds of the intervals over which arc lengths are to be computed.}

\item{type}{An integer specifying the bandwidth selection method used, see \code{\link{bw}}.}

\item{bootstraps}{An integer giving the number of bootstrap samples.}

\item{bootName}{The name of the .rds file to store the alKDEboot object.  May include a path.}

\item{...}{Arguments to be passed on to the control argument of the \code{\link{optim}} function.}

\item{x}{An alKDEboot object.}

\item{object}{An alKDEboot object.}

\item{newdata}{The data on which the estimated model is to be fitted.}
}
\value{
A generic S3 object with class alKDEboot.

alKDEboot.default: A list object (saved using \code{saveRDS} in the specified location) with the following components:
\itemize{
\item intercept: Did the model contain an intercept TRUE/FALSE?
\item coefficients: A vector of estimated coefficients.
\item coefDist The bootstrap parameter distribution.
\item bcoefficients: A vector of bootstrap coefficients, resulting from bootstrap estimation.
\item df: Degrees of freedom of the model.
\item se: The standard errors for the estimates resulting from bootstrap estimation.
\item error: The value of the objective function.
\item errorList: A vector of values of the objective function for each bootstrap sample.
\item fitted.values: A vector of estimated values.
\item residuals: The residuals resulting from the fitted model.
\item call: The call to the function.
\item h_y: The KDE bandwidth estimator for the dependent variable.
\item h_X: The KDE bandwidth estimator for the independent variables, i.e. \eqn{\mathbf{X}\underline{\hat{\beta}}}.
\item ALy: Arc length segments of the KDE cast over the dependent variable.
\item ALX: Arc length segments of the KDE cast over the independent variables \eqn{\mathbf{X}\underline{\hat{\beta}}}.
p1: The vector of quantiles in the domain of \eqn{y} corresponding to \code{q1}.
p2: The vector of quantiles in the domain of \eqn{y} corresponding to \code{q2}.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
}

summary.alKDEboot: A list of class summary.alKDEboot with the following components:
\itemize{
\item call: Original call to the \code{alKDEboot} function.
\item coefficients: A matrix with estimates, estimated errors, and 95\% parameter confidence intervals (based on the inverse empirical distribution function).
\item arclengths: A matrix of the arc length segments that were matched, for the dependent and independent variables.  The final row corresponds to the estimated bandwidth parameters for each, i.e. \code{h_y} and \code{h_X}, respectively.
\item r.squared: The \eqn{r^{2}} coefficient.
\item adj.r.squared: The adjusted \eqn{r^{2}} coefficient.
\item sigma: The residual standard error.
\item df: Degrees of freedom for the model.
\item error: Value of the objective function.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
\item residSum: Summary statistics for the distribution of the residuals.
\item errorSum: Summary statistics for the distribution of the value of the objective function.
}

print.summary.alKDEboot: The object passed to the function is returned invisibly.

predict.alKDEboot: A vector of predicted values resulting from the estimated model.
}
\description{
Bootstrap estimates, along with standard  errors and confidence intervals, of a linear model, resulting from arc length matching of kernel density estimates.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for alKDEboot.

\item \code{alKDEboot}: print method for alKDEboot.

\item \code{alKDEboot}: summary method for alKDEboot.

\item \code{summary.alKDEboot}: print method for summary.alKDEboot.

\item \code{formula}: formula method for alKDEboot.

\item \code{alKDEboot}: predict method for alKDEboot.
}}

