% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa4nlsJack.R
\name{kappa4nlsJack}
\alias{kappa4nlsJack}
\alias{kappa4nlsJack.default}
\alias{print.kappa4nlsJack}
\alias{summary.kappa4nlsJack}
\alias{print.summary.kappa4nlsJack}
\alias{kappa4nlsJack.formula}
\alias{predict.kappa4nlsJack}
\title{Sigmoidal curve fitting.}
\usage{
kappa4nlsJack(formula, data = list(), xin, lower, upper, tol, maxiter,
  jackName, ...)

\method{kappa4nlsJack}{default}(formula, data = list(), xin, lower = c(0,
  -5, -5), upper = c(10, 1, 1), tol = 1e-15, maxiter = 50000, jackName,
  ...)

\method{print}{kappa4nlsJack}(x, ...)

\method{summary}{kappa4nlsJack}(object, ...)

\method{print}{summary.kappa4nlsJack}(x, ...)

\method{kappa4nlsJack}{formula}(formula, data = list(), xin, lower, upper,
  tol, maxiter, jackName, ...)

\method{predict}{kappa4nlsJack}(object, newdata = NULL, ...)
}
\arguments{
\item{formula}{An LHS ~ RHS formula, specifying the linear model to be estimated.}

\item{data}{A data.frame which contains the variables in \code{formula}.}

\item{xin}{Numeric vector of length 3 containing initial values, for \eqn{\sigma}, \eqn{h}, and \eqn{k}.}

\item{lower}{A vector of lower constraints for the parameters to be estimated; defaults to c(0, -5, -5).}

\item{upper}{A vector of upper constraints for the parameters to be estimated; defaults to c(10, 1, 1).}

\item{tol}{Error tolerance level; defaults to 1e-15.}

\item{maxiter}{The maximum number of iterations allowed; defaults to 50000.}

\item{jackName}{The name of the .rds file to store the kappa4nlsJack object.  May include a path.}

\item{...}{Arguments to be passed on to the differential evolution function \code{\link{JDEoptim}}.}

\item{x}{A kappa4nlsJack object.}

\item{object}{A kappa4nlsJack object.}

\item{newdata}{The data on which the estimated model is to be fitted.}
}
\value{
A generic S3 object with class kappa4nlsJack.

kappa4nlsJack.default: A list object (saved using \code{saveRDS} in the specified location) with the following components:
\itemize{
\item intercept: Did the model contain an intercept TRUE/FALSE?
\item coefficients: A vector of estimated coefficients.
\item coefDist The jackknife parameter distribution.
\item jcoefficients: A vector of bias-corrected coefficients, resulting from jackknife estimation.
\item bias: The corrections applied in obtaining the bias-corrected estimates.
\item se: The standard errors for the estimates resulting from jackknife estimation.
\item error: The value of the objective function.
\item errorList: A vector of values of the objective function at jackknife points.
\item fitted.values: A vector of estimated values.
\item residuals: The residuals resulting from the fitted model.
\item call: The call to the function.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
}

summary.kappa4nlsJack: A list of class summary.kappa4nlsJack with the following components:
\itemize{
\item call: Original call to the \code{kappa4nlsJack} function.
\item coefficients: A matrix with estimates, estimated errors, and 95\% parameter confidence intervals (based on the inverse empirical distribution function).
\item r.squared: The \eqn{r^{2}} coefficient.
\item sigma: The residual standard error.
\item error: Value of the objective function.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
\item residSum: Summary statistics for the distribution of the residuals.
\item errorSum: Summary statistics for the distribution of the value of the objective function.
}

print.summary.kappa4nlsJack: The object passed to the function is returned invisibly.

predict.kappa4nlsJack: A vector of predicted values resulting from the estimated model.
}
\description{
Bias corrected jackknife estimates, along with standard  errors and confidence intervals, of a nonlinear model, resulting from  nonlinear least squares fitting of the four-parameter kappa sigmoidal function.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for kappa4nlsJack.

\item \code{kappa4nlsJack}: print method for kappa4nlsJack.

\item \code{kappa4nlsJack}: summary method for kappa4nlsJack.

\item \code{summary.kappa4nlsJack}: print method for summary.kappa4nlsJack.

\item \code{formula}: formula method for kappa4nlsJack.

\item \code{kappa4nlsJack}: predict method for kappa4nlsJack.
}}

