% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_Studio.R
\name{summarize_args_for_long_task}
\alias{summarize_args_for_long_task}
\title{Summarize arguments from shiny input}
\usage{
summarize_args_for_long_task(
  input,
  object_class,
  method = "configure",
  path_args = list(path_to_embeddings = NULL, path_to_textual_dataset = NULL,
    path_to_target_data = NULL, path_to_feature_extractor = NULL, destination_path =
    NULL, folder_name = NULL),
  override_args = list(),
  meta_args = list(py_environment_type = get_py_env_type(), py_env_name =
    get_py_env_name(), target_data_column = input$data_target_column, object_class =
    input$classifier_type)
)
}
\arguments{
\item{input}{Shiny input.}

\item{object_class}{\code{string} Class of the object.}

\item{method}{\code{string} Method of the class for which the arguments should
be extracted and prepared.}

\item{path_args}{\code{list} List containing the path to object that can not be exported
to another R session. These must be loaded in the session.}

\item{override_args}{\code{list} List containing all arguments that should be set manually.
The values override default values of the argument and values which are part of \code{input}.}

\item{meta_args}{\code{list} List containing information that are not relevant for the
arguments of the method but are necessary to set up the \code{shiny::ExtendedTask}
correctly.}
}
\value{
Returns a named \code{list} with the following entries:
\itemize{
\item args: Named \code{list} of all arguments necessary for the method of the class.
\item path_args: Named \code{list} of all paths for loading the objects missing in args.
\item meta_args: Named \code{list} of all arguments that are not part of the arguments of
the method but which are necessary to set up the \code{shiny::ExtendedTask} correctly.
}
}
\description{
This function extracts the input relevant for a specific
method of a specific class from shiny input.

In addition, it adds the path
to all objects which can not be exported to another R session. These object
must be loaded separately in the new session with the function \code{add_missing_args}.
The paths are intended to be used with \code{shiny::ExtendedTask}. The final preparation of the arguments
should be done with

The function can also be used to override the default value of
a method or to add value for arguments which are not part of shiny input
(use parameter \code{override_args}).
}
\note{
Please not that all list are named list of the format (argument_name=values).
}
\seealso{
Other Utils Studio Developers: 
\code{\link{add_missing_args}()},
\code{\link{create_data_embeddings_description}()},
\code{\link{long_load_target_data}()}
}
\concept{Utils Studio Developers}
