/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.aibd.model.lineargaussian;

import java.io.Serializable;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.util.FastMath;
import org.ddahl.aibd.FeatureAllocation;
import org.ddahl.aibd.distribution.AttractionIndianBuffetDistribution;
import org.ddahl.aibd.distribution.FeatureAllocationDistribution;
import org.ddahl.aibd.distribution.HasMass;
import org.ddahl.aibd.distribution.HasTemperature;
import org.ddahl.aibd.distribution.Permutation;
import org.ddahl.aibd.distribution.Similarity;
import org.ddahl.aibd.model.lineargaussian.LikelihoodComponents;
import org.ddahl.aibd.model.lineargaussian.LinearGaussianLatentFeatureModel;
import org.ddahl.aibd.util.Functions$;
import org.ddahl.aibd.util.MCMCAcceptanceMonitor1;
import org.ddahl.aibd.util.MCMCAcceptanceMonitor1$;
import org.ddahl.aibd.util.Misc$;
import org.ddahl.aibd.util.TimeMonitor;
import org.ddahl.aibd.util.TimeMonitor$;
import org.ddahl.commonsmath.Implicits$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BitSetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.parallel.immutable.ParVector;
import scala.collection.parallel.immutable.ParVector$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class PosteriorSimulation$ {
    public static final PosteriorSimulation$ MODULE$ = new PosteriorSimulation$();

    public Tuple3<FeatureAllocation[], int[][], double[][]> update4AIBD(FeatureAllocation featureAllocation, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm, double massPriorShape, double massPriorRate, int nPerShuffle, double temperaturePriorShape, double temperaturePriorRate, double maxStandardDeviationX, double maxStandardDeviationW, double sdProposedTemperature, double sdProposedStandardDeviationX, double sdProposedStandardDeviationW, double corProposedSdXSdW, int nOtherUpdatesPerAllocationUpdate, int nSamples, int thin, int progressWidth, RandomDataGenerator rdg, boolean rankOneUpdates, double newFeaturesTruncationDivisor) {
        int r;
        Tuple2.mcII.sp sp2;
        ObjectRef stateFA = ObjectRef.create((Object)featureAllocation);
        ObjectRef stateFAPrior = ObjectRef.create((Object)featureAllocationPrior);
        ObjectRef stateLGLFM = ObjectRef.create((Object)lglfm);
        MCMCAcceptanceMonitor1 monitorFA = MCMCAcceptanceMonitor1$.MODULE$.apply();
        MCMCAcceptanceMonitor1 monitorFAMass = MCMCAcceptanceMonitor1$.MODULE$.apply();
        MCMCAcceptanceMonitor1 monitorFAPermutation = MCMCAcceptanceMonitor1$.MODULE$.apply();
        MCMCAcceptanceMonitor1 monitorFATemperature = MCMCAcceptanceMonitor1$.MODULE$.apply();
        MCMCAcceptanceMonitor1 monitorLGLFM = MCMCAcceptanceMonitor1$.MODULE$.apply();
        TimeMonitor tmAll = TimeMonitor$.MODULE$.apply();
        TimeMonitor tmAllocation = TimeMonitor$.MODULE$.apply();
        TimeMonitor tmMass = TimeMonitor$.MODULE$.apply();
        TimeMonitor tmPermutation = TimeMonitor$.MODULE$.apply();
        TimeMonitor tmTemperature = TimeMonitor$.MODULE$.apply();
        TimeMonitor tmLGLFM = TimeMonitor$.MODULE$.apply();
        int nIterations = thin * nSamples;
        Tuple2.mcII.sp sp3 = progressWidth <= 0 ? new Tuple2.mcII.sp(0, 1) : (sp2 = (r = nSamples / progressWidth) == 0 ? new Tuple2.mcII.sp(nSamples, 1) : new Tuple2.mcII.sp(nSamples / r, r));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int width = sp2._1$mcI$sp();
        int rate = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(width, rate);
        Tuple2.mcII.sp sp5 = sp4;
        int width2 = sp5._1$mcI$sp();
        int rate2 = sp5._2$mcI$sp();
        if (width2 > 0) {
            Predef$.MODULE$.print((Object)new StringBuilder(5).append("[").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), width2)).append("]").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\b"), width2 + 1)).append("   ").toString());
        }
        FeatureAllocation[] resultFA = (FeatureAllocation[])Array$.MODULE$.ofDim(nSamples, ClassTag$.MODULE$.apply(FeatureAllocation.class));
        int[][] resultPermutation = (int[][])Array$.MODULE$.ofDim(nSamples, ((FeatureAllocation)stateFA.elem).nItems(), (ClassTag)ClassTag$.MODULE$.Int());
        double[][] resultOthers = (double[][])Array$.MODULE$.ofDim(nSamples, 4, (ClassTag)ClassTag$.MODULE$.Double());
        IntRef b = IntRef.create((int)1);
        while (b.elem <= nIterations) {
            tmAll.apply((JFunction0.mcV.sp & Serializable)() -> {
                block9: {
                    double d;
                    double d2;
                    int[] nArray;
                    stateFA$1.elem = (FeatureAllocation)monitorFA.apply((Function0 & Serializable)() -> (Tuple3)tmAllocation.apply((Function0 & Serializable)() -> MODULE$.updateFeatureAllocation((FeatureAllocation)stateFA$1.elem, (FeatureAllocationDistribution)stateFAPrior$1.elem, (LinearGaussianLatentFeatureModel)stateLGLFM$1.elem, rdg, rankOneUpdates, newFeaturesTruncationDivisor)));
                    Misc$.MODULE$.repeat(nOtherUpdatesPerAllocationUpdate, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        FeatureAllocationDistribution featureAllocationDistribution;
                        FeatureAllocationDistribution featureAllocationDistribution2;
                        FeatureAllocationDistribution featureAllocationDistribution3;
                        FeatureAllocationDistribution featureAllocationDistribution4 = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                        if (featureAllocationDistribution4 instanceof HasMass) {
                            FeatureAllocationDistribution featureAllocationDistribution5 = featureAllocationDistribution4;
                            featureAllocationDistribution3 = massPriorShape <= 0.0 || massPriorRate <= 0.0 ? featureAllocationDistribution5 : (FeatureAllocationDistribution)monitorFAMass.apply((Function0 & Serializable)() -> (Tuple3)tmMass.apply((Function0 & Serializable)() -> MODULE$.updateMass((FeatureAllocation)stateFA$1.elem, featureAllocationDistribution5, rdg, massPriorShape, massPriorRate)));
                        } else {
                            featureAllocationDistribution3 = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                        }
                        stateFAPrior$1.elem = featureAllocationDistribution3;
                        FeatureAllocationDistribution featureAllocationDistribution6 = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                        if (featureAllocationDistribution6 instanceof AttractionIndianBuffetDistribution) {
                            AttractionIndianBuffetDistribution attractionIndianBuffetDistribution = (AttractionIndianBuffetDistribution)featureAllocationDistribution6;
                            featureAllocationDistribution2 = nPerShuffle < 2 ? attractionIndianBuffetDistribution : (FeatureAllocationDistribution)monitorFAPermutation.apply((Function0 & Serializable)() -> (Tuple3)tmPermutation.apply((Function0 & Serializable)() -> MODULE$.updatePermutation((FeatureAllocation)stateFA$1.elem, attractionIndianBuffetDistribution, rdg, nPerShuffle)));
                        } else {
                            featureAllocationDistribution2 = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                        }
                        stateFAPrior$1.elem = featureAllocationDistribution2;
                        FeatureAllocationDistribution featureAllocationDistribution7 = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                        if (featureAllocationDistribution7 instanceof AttractionIndianBuffetDistribution) {
                            AttractionIndianBuffetDistribution attractionIndianBuffetDistribution = (AttractionIndianBuffetDistribution)featureAllocationDistribution7;
                            featureAllocationDistribution = temperaturePriorShape <= 0.0 || temperaturePriorRate <= 0.0 ? attractionIndianBuffetDistribution : (FeatureAllocationDistribution)monitorFATemperature.apply((Function0 & Serializable)() -> (Tuple3)tmTemperature.apply((Function0 & Serializable)() -> MODULE$.updateTemperature((FeatureAllocation)stateFA$1.elem, attractionIndianBuffetDistribution, rdg, temperaturePriorShape, temperaturePriorRate, sdProposedTemperature)));
                        } else {
                            featureAllocationDistribution = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                        }
                        stateFAPrior$1.elem = featureAllocationDistribution;
                        stateLGLFM$1.elem = sdProposedStandardDeviationX <= 0.0 || sdProposedStandardDeviationW <= 0.0 ? (LinearGaussianLatentFeatureModel)stateLGLFM$1.elem : (LinearGaussianLatentFeatureModel)monitorLGLFM.apply((Function0 & Serializable)() -> (Tuple3)tmLGLFM.apply((Function0 & Serializable)() -> MODULE$.updateSamplingModel((FeatureAllocation)stateFA$1.elem, (FeatureAllocationDistribution)stateFAPrior$1.elem, (LinearGaussianLatentFeatureModel)stateLGLFM$1.elem, rdg, maxStandardDeviationX, maxStandardDeviationW, sdProposedStandardDeviationX, sdProposedStandardDeviationW, corProposedSdXSdW)));
                    });
                    if (b$1.elem % thin != 0) break block9;
                    int index = (b$1.elem - 1) / thin;
                    resultFA$1[index] = (FeatureAllocation)stateFA$1.elem;
                    FeatureAllocationDistribution featureAllocationDistribution = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                    if (featureAllocationDistribution instanceof AttractionIndianBuffetDistribution) {
                        AttractionIndianBuffetDistribution attractionIndianBuffetDistribution = (AttractionIndianBuffetDistribution)featureAllocationDistribution;
                        nArray = attractionIndianBuffetDistribution.permutation().toArray();
                    } else {
                        nArray = (int[])Array$.MODULE$.ofDim(((FeatureAllocation)stateFA$1.elem).nItems(), (ClassTag)ClassTag$.MODULE$.Int());
                    }
                    resultPermutation$1[index] = nArray;
                    double[] dArray = resultOthers[index];
                    FeatureAllocationDistribution featureAllocationDistribution2 = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                    if (featureAllocationDistribution2 instanceof HasMass) {
                        FeatureAllocationDistribution featureAllocationDistribution3 = featureAllocationDistribution2;
                        d2 = ((HasMass)((Object)featureAllocationDistribution3)).mass();
                    } else {
                        d2 = 0.0;
                    }
                    dArray[0] = d2;
                    double[] dArray2 = resultOthers[index];
                    FeatureAllocationDistribution featureAllocationDistribution4 = (FeatureAllocationDistribution)stateFAPrior$1.elem;
                    if (featureAllocationDistribution4 instanceof AttractionIndianBuffetDistribution) {
                        double d3;
                        AttractionIndianBuffetDistribution attractionIndianBuffetDistribution = (AttractionIndianBuffetDistribution)featureAllocationDistribution4;
                        Similarity similarity = attractionIndianBuffetDistribution.similarity();
                        if (similarity instanceof HasTemperature) {
                            Similarity similarity2 = similarity;
                            d3 = ((HasTemperature)((Object)similarity2)).temperature();
                        } else {
                            d3 = 0.0;
                        }
                        d = d3;
                    } else {
                        d = 0.0;
                    }
                    dArray2[1] = d;
                    resultOthers$1[index][2] = ((LinearGaussianLatentFeatureModel)stateLGLFM$1.elem).standardDeviationX();
                    resultOthers$1[index][3] = ((LinearGaussianLatentFeatureModel)stateLGLFM$1.elem).standardDeviationW();
                    if (width2 > 0 && index % rate2 == 0) {
                        Predef$.MODULE$.print((Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\b"), 3));
                        Predef$.MODULE$.print((Object)"*");
                        Predef$.MODULE$.print((Object)" ");
                        Predef$.MODULE$.print((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%2d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((FeatureAllocation)stateFA$1.elem).nFeatures())})));
                    }
                }
            });
            ++b.elem;
        }
        if (width2 > 0) {
            Predef$.MODULE$.print((Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\b"), 3));
            Predef$.MODULE$.println((Object)"]  ");
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("Rank-one updates: ").append(rankOneUpdates).toString());
            Predef$.MODULE$.println((Object)"Lapse times:");
            Predef$.MODULE$.println((Object)new StringBuilder(9).append("  Total: ").append(tmAll).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(14).append("  Allocation: ").append(tmAllocation).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(8).append("  Mass: ").append(tmMass).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(15).append("  Permutation: ").append(tmPermutation).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(15).append("  Temperature: ").append(tmTemperature).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("  Sampling model: ").append(tmLGLFM).toString());
            Predef$.MODULE$.println((Object)"Acceptance rates:");
            Predef$.MODULE$.println((Object)new StringBuilder(14).append("  Allocation: ").append(monitorFA.rate()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(15).append("  Permutation: ").append(monitorFAPermutation.rate()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(15).append("  Temperature: ").append(monitorFATemperature.rate()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("  Sampling model: ").append(monitorLGLFM.rate()).toString());
        }
        return new Tuple3((Object)resultFA, (Object)resultPermutation, (Object)resultOthers);
    }

    public double update4AIBD$default$21() {
        return 1000.0;
    }

    public <T> Tuple3<FeatureAllocationDistribution, Object, Object> updateMass(FeatureAllocation featureAllocation, FeatureAllocationDistribution hasMassPrior, RandomDataGenerator rdg, double priorShape, double priorRate) {
        double posteriorShape = priorShape + (double)featureAllocation.nFeatures();
        double posteriorRate = priorRate + Functions$.MODULE$.harmonicNumber().apply(featureAllocation.nItems());
        return new Tuple3((Object)((HasMass)((Object)hasMassPrior)).updateMass(rdg.nextGamma(posteriorShape, 1.0 / posteriorRate)), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    public Tuple3<AttractionIndianBuffetDistribution, Object, Object> updatePermutation(FeatureAllocation featureAllocation, AttractionIndianBuffetDistribution aibdPrior, RandomDataGenerator rdg, int nPerShuffle) {
        Permutation proposedPermutation = aibdPrior.permutation().nPerShuffle(nPerShuffle).shuffle(rdg);
        AttractionIndianBuffetDistribution proposedAIBDPrior = aibdPrior.updatePermutation(proposedPermutation);
        double logMHRatio = proposedAIBDPrior.logProbability(featureAllocation) - aibdPrior.logProbability(featureAllocation);
        return logMHRatio > 0.0 || FastMath.log((double)rdg.nextUniform(0.0, 1.0)) < logMHRatio ? new Tuple3((Object)proposedAIBDPrior, (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)) : new Tuple3((Object)aibdPrior, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    public Tuple3<FeatureAllocationDistribution, Object, Object> updateTemperature(FeatureAllocation featureAllocation, AttractionIndianBuffetDistribution aibdPrior, RandomDataGenerator rdg, double temperatureShape, double temperatureRate, double sdProposedTemperature) {
        double proposedTemperature;
        Similarity similarity;
        Similarity similarity2 = aibdPrior.similarity();
        if (similarity2 instanceof HasTemperature) {
            similarity = similarity2;
            proposedTemperature = rdg.nextGaussian(((HasTemperature)((Object)similarity)).temperature(), sdProposedTemperature);
            if (proposedTemperature < 0.0) {
                return new Tuple3((Object)aibdPrior, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1));
            }
        } else {
            return new Tuple3((Object)aibdPrior, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0));
        }
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)((HasTemperature)((Object)similarity)).temperature()), (Object)BoxesRunTime.boxToDouble((double)proposedTemperature), (Object)aibdPrior.updateSimilarity(((HasTemperature)((Object)similarity)).updateTemperature(proposedTemperature)));
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        double currentTemperature = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        double proposedTemperature2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        AttractionIndianBuffetDistribution proposedAIBDPrior = (AttractionIndianBuffetDistribution)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)currentTemperature), (Object)BoxesRunTime.boxToDouble((double)proposedTemperature2), (Object)proposedAIBDPrior);
        Tuple3 tuple34 = tuple33;
        double currentTemperature2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
        double proposedTemperature3 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
        AttractionIndianBuffetDistribution proposedAIBDPrior2 = (AttractionIndianBuffetDistribution)tuple34._3();
        GammaDistribution gammaDistribution = new GammaDistribution(null, temperatureShape, 1.0 / temperatureRate);
        double logMHRatio = proposedAIBDPrior2.logProbability(featureAllocation) + gammaDistribution.logDensity(proposedTemperature3) - aibdPrior.logProbability(featureAllocation) - gammaDistribution.logDensity(currentTemperature2);
        return logMHRatio > 0.0 || FastMath.log((double)rdg.nextUniform(0.0, 1.0)) < logMHRatio ? new Tuple3((Object)proposedAIBDPrior2, (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)) : new Tuple3((Object)aibdPrior, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    public Tuple3<LinearGaussianLatentFeatureModel, Object, Object> updateSamplingModel(FeatureAllocation featureAllocation, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm, RandomDataGenerator rdg, double maxStandardDeviationX, double maxStandardDeviationW, double sdProposedStandardDeviationX, double sdProposedStandardDeviationW, double corProposedSdXSdW) {
        double m1 = lglfm.standardDeviationX();
        double m2 = lglfm.standardDeviationW();
        double proposedStandardDeviationX = rdg.nextGaussian(m1, sdProposedStandardDeviationX);
        if (proposedStandardDeviationX < 0.0 || proposedStandardDeviationX > maxStandardDeviationX) {
            return new Tuple3((Object)lglfm, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1));
        }
        double proposedStandardDeviationW = rdg.nextGaussian(m2 + sdProposedStandardDeviationW / sdProposedStandardDeviationX * corProposedSdXSdW * (proposedStandardDeviationX - m1), FastMath.sqrt((double)((1.0 - corProposedSdXSdW * corProposedSdXSdW) * sdProposedStandardDeviationW * sdProposedStandardDeviationW)));
        if (proposedStandardDeviationW < 0.0 || proposedStandardDeviationW > maxStandardDeviationW) {
            return new Tuple3((Object)lglfm, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1));
        }
        LinearGaussianLatentFeatureModel proposedLGLFM = lglfm.updateStandardDeviations(proposedStandardDeviationX, proposedStandardDeviationW);
        double logMHRatio = proposedLGLFM.logLikelihood(featureAllocation) - lglfm.logLikelihood(featureAllocation);
        return logMHRatio > 0.0 || FastMath.log((double)rdg.nextUniform(0.0, 1.0)) < logMHRatio ? new Tuple3((Object)proposedLGLFM, (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)) : new Tuple3((Object)lglfm, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    public Tuple3<FeatureAllocation, Object, Object> updateFeatureAllocation(FeatureAllocation featureAllocation, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm, RandomDataGenerator rdg, boolean rankOneUpdates, double newFeaturesTruncationDivisor) {
        int nItems = lglfm.N();
        double logNewFeaturesTruncationDivisor = FastMath.log((double)newFeaturesTruncationDivisor);
        ObjectRef state = ObjectRef.create((Object)featureAllocation);
        IntRef accepts = IntRef.create((int)0);
        IntRef attempts = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nItems).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Tuple3<FeatureAllocation, Object, Object> tuple3 = MODULE$.updateFeatureAllocationOfExistingOneByOne(i, (FeatureAllocation)state$1.elem, featureAllocationPrior, lglfm, rdg, rankOneUpdates);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            FeatureAllocation stateNew = (FeatureAllocation)tuple3._1();
            int n = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int d = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)stateNew, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)d));
            Tuple3 tuple33 = tuple32;
            FeatureAllocation stateNew2 = (FeatureAllocation)tuple33._1();
            int n2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            int d2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            state$1.elem = stateNew2;
            accepts$1.elem += n2;
            attempts$1.elem += d2;
            state$1.elem = MODULE$.updateFeatureAllocationOfSingletons(i, (FeatureAllocation)state$1.elem, featureAllocationPrior, lglfm, rdg, logNewFeaturesTruncationDivisor);
        });
        return new Tuple3((Object)((FeatureAllocation)state.elem), (Object)BoxesRunTime.boxToInteger((int)accepts.elem), (Object)BoxesRunTime.boxToInteger((int)attempts.elem));
    }

    public double updateFeatureAllocation$default$6() {
        return 1000.0;
    }

    private double logPosterior0(int i, FeatureAllocation fa, Option<LikelihoodComponents> likelihoodComponentsOption, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm) {
        return featureAllocationPrior.logProbability(i, fa) + (likelihoodComponentsOption.isDefined() ? lglfm.logLikelihood((LikelihoodComponents)likelihoodComponentsOption.get()) : lglfm.logLikelihood(fa));
    }

    private Tuple2<FeatureAllocation, Object> logPosterior1(int i, FeatureAllocation fa, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm) {
        return new Tuple2((Object)fa, (Object)BoxesRunTime.boxToDouble((double)(featureAllocationPrior.logProbability(i, fa) + lglfm.logLikelihood(fa))));
    }

    private Tuple2<FeatureAllocation, Object> logPosterior2(int i, FeatureAllocation fa, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm, LikelihoodComponents lc) {
        return new Tuple2((Object)fa, (Object)BoxesRunTime.boxToDouble((double)(featureAllocationPrior.logProbability(i, fa) + lglfm.logLikelihood(lglfm.allocateFeaturesFor(i, lc, fa.matrix()[i])))));
    }

    public FeatureAllocation updateFeatureAllocationOfSingletons(int i, FeatureAllocation featureAllocation, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm, RandomDataGenerator rdg, double logNewFeaturesTruncationDivisor) {
        FeatureAllocation existing = (FeatureAllocation)featureAllocation.partitionBySingletonsOf(i)._2();
        Tuple2<FeatureAllocation, Object> tuple2 = this.logPosterior1(i, existing, featureAllocationPrior, lglfm);
        IndexedSeq weights = this.engine$1(Nil$.MODULE$.$colon$colon(tuple2), Double.NEGATIVE_INFINITY, i, featureAllocationPrior, lglfm, logNewFeaturesTruncationDivisor).toIndexedSeq();
        return (FeatureAllocation)Implicits$.MODULE$.RandomDataGeneratorImprovements(rdg).nextItem(weights, true)._1();
    }

    public Tuple3<FeatureAllocation, Object, Object> updateFeatureAllocationOfExistingByEnumeration(int i, FeatureAllocation featureAllocation, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm, RandomDataGenerator rdg, boolean parallel, boolean rankOneUpdates) {
        Vector vector;
        Vector<FeatureAllocation> proposals = featureAllocation.enumerateFor(i);
        if (rankOneUpdates) {
            if (proposals.isEmpty()) {
                vector = (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
            } else {
                LikelihoodComponents lc1 = lglfm.computeLikelihoodComponents((FeatureAllocation)proposals.head());
                LikelihoodComponents lc2 = lglfm.deallocateFeaturesFor(i, lc1);
                vector = parallel ? ((ParVector)ParVector$.MODULE$.apply(proposals).map((Function1 & Serializable)x$4 -> MODULE$.logPosterior2(i, (FeatureAllocation)x$4, featureAllocationPrior, lglfm, lc2))).toVector() : (Vector)proposals.map((Function1 & Serializable)x$5 -> MODULE$.logPosterior2(i, (FeatureAllocation)x$5, featureAllocationPrior, lglfm, lc2));
            }
        } else {
            vector = parallel ? ((ParVector)ParVector$.MODULE$.apply(proposals).map((Function1 & Serializable)x$6 -> MODULE$.logPosterior1(i, (FeatureAllocation)x$6, featureAllocationPrior, lglfm))).toVector() : (Vector)proposals.map((Function1 & Serializable)x$7 -> MODULE$.logPosterior1(i, (FeatureAllocation)x$7, featureAllocationPrior, lglfm));
        }
        Vector logWeights = vector;
        return new Tuple3(Implicits$.MODULE$.RandomDataGeneratorImprovements(rdg).nextItem((IndexedSeq)logWeights, true)._1(), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    public Tuple3<FeatureAllocation, Object, Object> updateFeatureAllocationOfExistingOneByOne(int i, FeatureAllocation featureAllocation, FeatureAllocationDistribution featureAllocationPrior, LinearGaussianLatentFeatureModel lglfm, RandomDataGenerator rdg, boolean rankOneUpdates) {
        if (featureAllocation.nFeatures() == 0) {
            return new Tuple3((Object)featureAllocation, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0));
        }
        IntRef accepts = IntRef.create((int)0);
        IntRef attempts = IntRef.create((int)0);
        ObjectRef state = ObjectRef.create((Object)featureAllocation);
        ObjectRef stateMap = ObjectRef.create(((FeatureAllocation)state.elem).asCountMap());
        ObjectRef stateLikelihoodComponentsOption = ObjectRef.create((Object)(rankOneUpdates ? new Some((Object)lglfm.computeLikelihoodComponents((FeatureAllocation)state.elem)) : None$.MODULE$));
        DoubleRef stateLogPosterior = DoubleRef.create((double)this.logPosterior0(i, (FeatureAllocation)state.elem, (Option<LikelihoodComponents>)((Option)stateLikelihoodComponentsOption.elem), featureAllocationPrior, lglfm));
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.intArrayOps(rdg.nextPermutation(((FeatureAllocation)state.elem).nFeatures(), ((FeatureAllocation)state.elem).nFeatures())), (Function1)(JFunction1.mcZI.sp & Serializable)j -> !((FeatureAllocation)state$2.elem).isSingleton(i, j)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            block0: {
                FeatureAllocation proposal = ((BitSetOps)((FeatureAllocation)state$2.elem).features().apply(j)).contains(i) ? ((FeatureAllocation)state$2.elem).remove(i, j) : ((FeatureAllocation)state$2.elem).add(i, j);
                Map<Tuple2<BitSet, Object>, Object> proposalMap = proposal.asCountMap();
                None$ proposalLikelihoodComponentsOption = rankOneUpdates ? new Some((Object)lglfm.reallocateFeaturesFor(i, (LikelihoodComponents)((Option)stateLikelihoodComponentsOption$1.elem).get(), proposal.matrixRow(i))) : None$.MODULE$;
                double proposalLogPosterior = MODULE$.logPosterior0(i, proposal, (Option<LikelihoodComponents>)proposalLikelihoodComponentsOption, featureAllocationPrior, lglfm);
                double logMHRatio = proposalLogPosterior - stateLogPosterior$1.elem - Functions$.MODULE$.logOnInt().apply(BoxesRunTime.unboxToInt((Object)((Map)stateMap$1.elem).apply((Object)new Tuple2(((FeatureAllocation)state$2.elem).features().apply(j), ((FeatureAllocation)state$2.elem).sizes().apply(j))))) + Functions$.MODULE$.logOnInt().apply(BoxesRunTime.unboxToInt((Object)proposalMap.apply((Object)new Tuple2(proposal.features().apply(j), proposal.sizes().apply(j)))));
                ++attempts$2.elem;
                if (!(logMHRatio >= 0.0) && !(FastMath.log((double)rdg.nextUniform(0.0, 1.0)) < logMHRatio)) break block0;
                ++accepts$2.elem;
                state$2.elem = proposal;
                stateMap$1.elem = proposalMap;
                stateLikelihoodComponentsOption$1.elem = proposalLikelihoodComponentsOption;
                stateLogPosterior$1.elem = proposalLogPosterior;
            }
        });
        return new Tuple3((Object)((FeatureAllocation)state.elem), (Object)BoxesRunTime.boxToInteger((int)accepts.elem), (Object)BoxesRunTime.boxToInteger((int)attempts.elem));
    }

    private final List engine$1(List weights, double max, int i$1, FeatureAllocationDistribution featureAllocationPrior$2, LinearGaussianLatentFeatureModel lglfm$2, double logNewFeaturesTruncationDivisor$2) {
        List expanded;
        while (true) {
            FeatureAllocation newCumState = ((FeatureAllocation)((Tuple2)weights.head())._1()).add(i$1);
            double newLogWeight = this.logPosterior1(i$1, newCumState, featureAllocationPrior$2, lglfm$2)._2$mcD$sp();
            Tuple2 tuple2 = new Tuple2((Object)newCumState, (Object)BoxesRunTime.boxToDouble((double)newLogWeight));
            expanded = weights.$colon$colon((Object)tuple2);
            if (newLogWeight < max - logNewFeaturesTruncationDivisor$2) break;
            max = newLogWeight > max ? newLogWeight : max;
            weights = expanded;
        }
        return expanded;
    }

    private PosteriorSimulation$() {
    }
}

