% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logPosteriorLGLFM.R
\name{logPosteriorLGLFM}
\alias{logPosteriorLGLFM}
\title{Log of the Posterior Density from the Linear Gaussian Latent Feature Model}
\usage{
logPosteriorLGLFM(
  featureAllocation,
  distribution,
  X,
  precisionX,
  precisionA,
  sdX,
  sdA,
  implementation = "scala"
)
}
\arguments{
\item{featureAllocation}{An N-by-K binary feature allocation matrix.}

\item{distribution}{A prior distribution of feature allocations, i.e., a
result from \code{\link{ibp}} or \code{\link{aibd}}.}

\item{X}{An N-by-D matrix of observed data.}

\item{precisionX}{The scalar precision of the data error variance.  This must
be specified if \code{sdX} is missing.}

\item{precisionA}{The scalar precision of a latent feature.  This must be
specified if \code{sdA} is missing.}

\item{sdX}{The scalar standard deviation of the data error variance.  This
must be specified if \code{precisionX} is missing.}

\item{sdA}{The scalar precision of a latent feature.  This must be specified
if \code{precisionA} is missing.}

\item{implementation}{The default of \code{"scala"} should be used.  The \code{"R"} option is not
a supported implementation.}
}
\value{
A numeric vector giving the log of the unnormalized posterior
  density.
}
\description{
The log of the unnormalized posterior density of a feature allocation from
the linear Gaussian latent feature model (LGLFM) is computed. The standard deviation
of the error term (\code{sdX}) may be supplied or the associated precision
(\code{precisionX}) can be provided instead. Likewise, only one of \code{sdA}
and \code{precisionA} should be supplied.
}
\examples{
\donttest{ # Regardless of size, the initial warmup can exceed CRAN's 5 seconds threshold
sigx <- 0.1
siga <- 1.0
dimA <- 1
nItems <- 8  # Should be a multiple of 4
Z <- matrix(c(1,0,1,1,0,1,0,0),byrow=TRUE,nrow=nItems,ncol=2)
A <- matrix(rnorm(ncol(Z)*dimA,sd=siga),nrow=ncol(Z),ncol=dimA)
e <- rnorm(nrow(Z)*ncol(A),0,sd=sigx)
X <- Z \%*\% A + e
logLikelihoodLGLFM(Z, X, sdX=sigx, sdA=siga)
logPosteriorLGLFM(Z, ibp(1,nItems), X, sdX=sigx, sdA=siga)

\dontshow{
rscala::scalaDisconnect(aibd:::s)
}
}

}
