% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_missing.R
\name{ahp.missing}
\alias{ahp.missing}
\title{Impute missing observations using the method in \insertCite{Harker1987;textual}{ahpsurvey}}
\usage{
ahp.missing(ahpmat, atts, round = FALSE, limit = FALSE)
}
\arguments{
\item{ahpmat}{A list of pairwise comparison matrices of each decision maker generated by \code{ahp.mat}.}

\item{atts}{A list of attributes in the correct order}

\item{round}{Rounds the imputation values of the matrix to the nearest integer if \code{TRUE}. Defaults to \code{FALSE}.}

\item{limit}{If set to \code{TRUE}, if the imputation value is larger than 9 or smaller than 1/9, the value is converted to 9 and 1/9 respectively. Defaults to \code{FALSE}.}
}
\value{
A list of matrices with all \code{NA} values imputed.
}
\description{
Imputes the missing values of a list of matrices produced by \code{ahp.mat} using the methods and assumptions made in \insertCite{Harker1987;textual}{ahpsurvey}. Missing values must be coded as \code{NA}. As suggested in \insertCite{Harker1987;textual}{ahpsurvey}, a minimum of n-1 comparisons must be made, where n is the number of attributes (assuming that the decision-maker is perfectly consistent). Note that the algorithm assumes that the NA values will be imputed under perfect consistency with the other pairwise comparisons made.
}
\examples{

library(magrittr)

atts <- c('cult', 'fam', 'house', 'jobs', 'trans')

data(city200)

set.seed(42)
## Make a dataframe that is missing at random
missing.df <- city200[1:10,]
for (i in 1:10){
  missing.df[i, round(stats::runif(1,1,10))] <- NA
}
missingahp <- ahp.mat(missing.df, atts, negconvert = TRUE)
ahp.missing(missingahp, atts)

}
\references{
\insertAllCited{}
}
\author{
Frankie Cho
}
