% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahn_main.R
\name{summary.ahn}
\alias{summary.ahn}
\title{Summary Artificial Hydrocarbon Network}
\usage{
\method{summary}{ahn}(x, ...)
}
\arguments{
\item{x}{an object of class "\code{ahn}" produced from the \link{fit} function.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
summary description of the AHN.
}
\description{
Summary method for objects of class \code{ahn}.
}
\examples{
\dontrun{
# Create data
x <- 2 * runif(1000) - 1;
x <- sort(x)

y <- (x < 0.1) * (0.05 * runif(100) + atan(pi*x)) +
    (x >= 0.1 & x < 0.6) * (0.05 * runif(1000) + sin(pi*x)) +
    (x >= 0.6) * (0.05 * runif(1000) + cos(pi*x))

# Create Sigma list
Sigma <- list(X = data.frame(x = x), Y = data.frame(y = y))

# Train AHN
ahn <- fit(Sigma, 5, 0.01, 500)

# Summary AHN
summary(ahn)
}

}
