% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gd.R
\name{gd}
\alias{gd}
\title{Grantham deviation}
\usage{
gd(
  x,
  c_min,
  c_max,
  p_min,
  p_max,
  v_min,
  v_max,
  alpha = 1.833,
  beta = 0.1018,
  gamma = 0.000399,
  rho = 50.723
)
}
\arguments{
\item{x}{A character vector of one-letter amino acid codes, indicating
missense substitutions.}

\item{c_min}{Amino acid composition, minimum value.}

\item{c_max}{Amino acid, composition, maximum value.}

\item{p_min}{Amino acid polarity, minimum value.}

\item{p_max}{Amino acid polarity, maximum value.}

\item{v_min}{Amino acid molecular volume, maximum value.}

\item{v_max}{Amino acid molecular volume, maximum value.}

\item{alpha}{The constant \eqn{\alpha} in Grantham's equation. It is the
square inverse of the mean of the composition property.}

\item{beta}{The constant \eqn{\beta} in Grantham's equation. It is the
square inverse of the mean of the polarity property.}

\item{gamma}{The constant \eqn{\gamma} in Grantham's equation. It is the
square inverse of the mean of the molecular volume property.}

\item{rho}{Grantham's distances reported in Table 2, Science (1974).
185(4154): 862--4 by R. Grantham, are scaled by a factor (here named
\eqn{\rho}) such that the mean value of all distances are 100. The \code{rho}
parameter allows this factor \eqn{\rho} to be changed. By default
\eqn{\rho=50.723}, the same value used by Grantham. This value is
originally mentioned in the caption of Table 2 of the aforementioned paper.}
}
\value{
A numeric vector of Grantham deviations. Each deviation corresponds
to one of the amino acids indicated in \code{x}.
}
\description{
This function calculates the Grantham deviation (\eqn{\mathrm{gd}}):

\deqn{\mathrm{gd} = \rho \left((\alpha\ \mathrm{dev}^2(c_x, c_{min}, c_{max}) + \beta\ \mathrm{dev}^2(p_x, p_{min}, p_{max}) + \gamma\ \mathrm{dev}^2(v_x, v_{min}, v_{max})\right)^\frac{1}{2}}

where \eqn{c_x} is the value for composition \eqn{c} of amino acid \eqn{x},
i.e. the atomic weight ratio of hetero (noncarbon) elements in end groups or
rings to carbons in the side chain; \eqn{p_x} is the value for polarity
\eqn{p} of amino acid \eqn{x}; and, \eqn{v_x} is the value for molecular
volume \eqn{v} of amino acid \eqn{x}.

\eqn{c_x}, \eqn{p_x} and \eqn{v_x} are looked up in
\link[grantham:amino_acids_properties]{grantham::amino_acids_properties} based on the amino acid identities passed
in \code{x}. The function \eqn{\mathrm{dev}} is implemented in \code{\link[=dev]{dev()}}. Remaining
variables in the equation are arguments to \code{gd()} and hence are explained
below in the Arguments section.
}
\examples{
gd('S', c_min = 0.39, c_max = 0.74, p_min =4.9, p_max =8.6, v_min = 3, v_max = 32.5)

}
\seealso{
\code{\link[=gv]{gv()}}, \code{\link[=dev]{dev()}}
}
