% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frostDays.R
\name{frostDays}
\alias{frostDays}
\title{Number of frost days}
\usage{
frostDays(mn, dates, iniday = "07-01", endday = "06-30", thres = 0)
}
\arguments{
\item{mn}{vector of daily minimum temperature series.}

\item{dates}{vector of dates corresponding with daily temprature series}

\item{iniday}{first day of the year ("dd-mm") when frost occurrence will be considered.}

\item{endday}{last day of the year ("dd-mm") when frost occurrence will be considered.}

\item{thres}{temperature threshold considered to trigger frost occurrence (0 by default).}
}
\value{
A numeric vector with the annual number of frost days is returned.
}
\description{
Calculates the number of frost days within a predefined period.
}
\details{
Despite the logical threshold of temperature is 0 ºC to determine frost occurrence, the argument "thres" is open to change in case of different units of temperature.
}
\examples{


frostDays(mn = daily_tmin,
           dates = seq.Date(as.Date('1981-01-01'),
                             as.Date('2010-12-31'), by ='day'),
           iniday = '07-01',
           endday = '06-30')

}
