% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglwbysm.R
\name{rglwbysm}
\alias{rglwbysm}
\title{Bayesian multivariate analysis of AFT model for selected covariates using regularization method.}
\usage{
rglwbysm(m, n, STime, Event, nc, ni, alpha, data)
}
\arguments{
\item{m}{Starting column number of covariates of study from high dimensional entered data.}

\item{n}{Ending column number of covariates of study from high dimensional entered data.}

\item{STime}{name of survival time in data}

\item{Event}{name of event status in data. 0 is for censored and 1 for occurrence of event.}

\item{nc}{number of markov chain.}

\item{ni}{number of iteration for MCMC.}

\item{alpha}{It is chosen value between 0 and 1 to know the regularization method. alpha=1 for Lasso,
alpha=0 for Ridge and alpha between 0 and 1 for elastic net regularization.}

\item{data}{High dimensional gene expression data that contains event status, survival time and and set of covariates.}
}
\value{
Data frame is containing posterior estimates mean, sd, credible intervals, n.eff and Rhat for beta's, sigma, alpha, tau and deviance (DIC information) of the model for the selected covariates using regularization technique. beta's of regression coefficient of the model. beta[1] is for intercept and others are for covariates (which is/are chosen order as columns in data). alpha is shape parameter of the distribution. 'sigma' is the scale parameter of the distribution.
}
\description{
Provides posterior Estimates of selected variable in AFT model for multivariable(maximum 5 at a time) in high dimensional gene expression data with MCMC.Incorporated variable selection has been done with regularization technique. It also deals covariates with missing values.
}
\details{
Here weibull distribution has been used for AFT model with MCMC.
This function deals covariates (in data) with missing values. Missing value in any column (covariate) is replaced by mean of that particular covariate.
}
\examples{
##
data(hdata)
rglwbysm(9,45,STime="os",Event="death",2,10,1,hdata)
##

}
\references{
Prabhash et al(2016)<doi:10.21307/stattrans-2016-046>
}
\seealso{
wbysuni,wbysmv, rglwbysu, aftbybmv
}
\author{
Atanu Bhattacharjee, Gajendra Kumar Vishwakarma and Pragya Kumari
}
