% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy.GG.R
\name{fuzzy.GG}
\alias{fuzzy.GG}
\title{Gath Geva Clustering}
\usage{
fuzzy.GG(X, K, m, max.iteration, threshold, member.init, RandomNumber = 0,
  print.result = 0)
}
\arguments{
\item{X}{dataset (matrix/data frame)}

\item{K}{number of cluster}

\item{m}{fuzzyfier}

\item{max.iteration}{maximum iteration for convergence}

\item{threshold}{convergence criteria}

\item{member.init}{membership object or matrix that will be used for initialized}

\item{RandomNumber}{random number for start initializing}

\item{print.result}{print result (0/1)}
}
\value{
Fuzzy Clustering object
}
\description{
Gath Geva for Fuzzy Clustering
}
\details{
This function perform Gath Geva algorithm by Gath-Geva (1989).
Gath Geva is one of fuzzy clustering methods to clustering dataset
become K cluster. Number of cluster (K) must be greater than 1. To control the overlaping
or fuzziness of clustering, parameter m must be specified.
Maximum iteration and threshold is specific number for convergencing the cluster.
Random Number is number that will be used for seeding to firstly generate fuzzy membership matrix.

Clustering will produce fuzzy membership matrix (U) and fuzzy cluster centroid (V).
The greatest value of membership on data point will determine cluster label.
Centroid or cluster center can be use to interpret the cluster. Both membership and centroid produced by
calculating mathematical distance. Gath Geva distance with Covariance Cluster and norm distribution assumption
}
\section{Slots}{

\describe{
\item{\code{centroid}}{centroid matrix}

\item{\code{distance}}{distance matrix}

\item{\code{func.obj}}{function objective}

\item{\code{call.func}}{called function}

\item{\code{fuzzyfier}}{fuzzyness parameter}

\item{\code{method.fuzzy}}{method of fuzzy clustering used}

\item{\code{member}}{membership matrix}

\item{\code{hard.label}}{hard.label}
}}
\examples{
fuzzy.GG(iris[,1:4],K=2,m=2,max.iteration=20,threshold=1e-3,RandomNumber=1234)
}
\references{
Gath and A.B. Geva,(1989) Unsupervised Optimal Fuzzy Clustering
Balasko, B., Abonyi, J., & Feil, B. (2002). Fuzzy Clustering and Data Analysis Toolbox: For Use with Matlab. Veszprem, Hungary.
}

