% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adproclus_classes.R
\name{plot.adpc}
\alias{plot.adpc}
\title{Plotting a (low dimensional) ADPROCLUS solution}
\usage{
\method{plot}{adpc}(x, type = "network", ...)
}
\arguments{
\item{x}{Object of class \code{adpc}. (Low dimensional) ADPROCLUS solution}

\item{type}{Choice for type of plot: one of \code{"network", "profiles",
"vars_by_comp"}. Default: \code{"network"}. Partial matching allowed.}

\item{...}{additional arguments will be passed on to the functions
\code{plot_cluster_network(), plot_profiles(), plot_vars_by_comp()}}
}
\value{
Invisibly returns the input model.
}
\description{
When passing a (low dimensional) ADPROCLUS solution of class \code{adpc} to
the generic \code{plot()}, this method plots the solution in one of the
following three ways:
\describe{
\item{Network}{Each cluster is a vertex and
the edge between two vertices represents the overlap between the
corresponding clusters. The size of a vertex corresponds to the cluster size.
The overlap is represented through color, width and numerical label of the
edge. The numerical edge-labels can be relative
(number of overlap observations / total observations)
or absolute (number of observations in both clusters).}
\item{Profiles}{Plot the profile matrix (\eqn{P}
for full dimensional model, \eqn{C} for low dimensional model)
in the style of a correlation plot to visualize the relation of each cluster
with each variable.}
\item{Variables by components}{Plot the low dimensional
component-by-variable matrix \eqn{B'} in the style of a
correlation plot to visualize the relation of each component with each
original variable. \strong{NOTE:} Only works for low dimensional ADPROCLUS.}
}
}
\examples{
# Loading a test dataset into the global environment
x <- stackloss

# Quick low dimensional clustering with K = 3 clusters and S = 1 dimensions
clust <- adproclus_low_dim(x, 3, 1)

# Produce three plots of the model
plot(clust, type = "network")
plot(clust, type = "profiles")
plot(clust, type = "vars_by_comp")
}
