% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_varval_list}
\alias{assert_varval_list}
\title{Is an Argument a Variable-Value List?}
\usage{
assert_varval_list(
  arg,
  required_elements = NULL,
  accept_expr = FALSE,
  accept_var = FALSE,
  optional = FALSE
)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{required_elements}{A \code{character} vector of names that must be present in \code{arg}}

\item{accept_expr}{Should expressions on the right hand side be accepted?}

\item{accept_var}{Should unnamed variable names (e.g. \code{vars(USUBJID)}) on the
right hand side be accepted?}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown.}
}
\value{
The function throws an error if \code{arg} is not a list of variable-value expressions.
Otherwise, the input it returned invisibly.
}
\description{
Checks if the argument is a list of \code{quosures} where the expressions are
variable-value pairs. The value can be a symbol, a string, a numeric, or
\code{NA}. More general expression are not allowed.
}
\examples{
example_fun <- function(vars) {
  assert_varval_list(vars)
}
example_fun(vars(DTHDOM = "AE", DTHSEQ = AESEQ))

try(example_fun(vars("AE", DTSEQ = AESEQ)))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_function}()},
\code{\link{assert_has_variables}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_order_vars}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()}
}
\author{
Stefan Bundfuss, Thomas Neitmann
}
\concept{assertion}
\keyword{assertion}
