% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_list_element}
\alias{assert_list_element}
\title{Is an Element of a List of Lists/Classes Fulfilling a Condition?}
\usage{
assert_list_element(list, element, condition, message_text, ...)
}
\arguments{
\item{list}{A list to be checked

A list of named lists or classes is expected.}

\item{element}{The name of an element of the lists/classes

A character scalar is expected.}

\item{condition}{Condition to be fulfilled

The condition is evaluated for each element of the list. The element of the
lists/classes can be referred to by its name, e.g., \code{censor == 0} to check
the \code{censor} field of a class.}

\item{message_text}{Text to be displayed in the message

The text should describe the condition to be fulfilled, e.g., "For events
the censor values must be zero.".}

\item{...}{Objects required to evaluate the condition

If the condition contains objects apart from the element, they have to be
passed to the function. See the second example below.}
}
\value{
An error if the condition is not meet. The input otherwise.
}
\description{
Checks if the elements of a list of named lists/classes fulfill a certain
condition. If not, an error is issued and all elements of the list not
fulfilling the condition are listed.
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_function}()},
\code{\link{assert_has_variables}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_order_vars}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\author{
Stefan Bundfuss
}
\concept{assertion}
\keyword{assertion}
