% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt.R
\name{restrict_imputed_dtc_dt}
\alias{restrict_imputed_dtc_dt}
\title{Restrict Imputed DTC date to Minimum/Maximum Dates}
\usage{
restrict_imputed_dtc_dt(dtc, imputed_dtc, min_dates, max_dates)
}
\arguments{
\item{dtc}{The \code{'--DTC'} date to impute

A character date is expected in a format like \code{yyyy-mm-dd} or
\code{yyyy-mm-ddThh:mm:ss}. Trailing components can be omitted and \code{-} is a
valid "missing" value for any component.}

\item{imputed_dtc}{The imputed DTC date}

\item{min_dates}{Minimum dates

A list of dates is expected. It is ensured that the imputed date is not
before any of the specified dates, e.g., that the imputed adverse event start
date is not before the first treatment date. Only dates which are in the
range of possible dates of the \code{dtc} value are considered. The possible dates
are defined by the missing parts of the \code{dtc} date (see example below). This
ensures that the non-missing parts of the \code{dtc} date are not changed.
A date or date-time object is expected.
For example

\if{html}{\out{<div class="sourceCode r">}}\preformatted{impute_dtc_dtm(
  "2020-11",
  min_dates = list(
   ymd_hms("2020-12-06T12:12:12"),
   ymd_hms("2020-11-11T11:11:11")
  ),
  highest_imputation = "M"
)
}\if{html}{\out{</div>}}

returns \code{"2020-11-11T11:11:11"} because the possible dates for \code{"2020-11"}
range from \code{"2020-11-01T00:00:00"} to \code{"2020-11-30T23:59:59"}. Therefore
\code{"2020-12-06T12:12:12"} is ignored. Returning \code{"2020-12-06T12:12:12"} would
have changed the month although it is not missing (in the \code{dtc} date).}

\item{max_dates}{Maximum dates

A list of dates is expected. It is ensured that the imputed date is not after
any of the specified dates, e.g., that the imputed date is not after the data
cut off date. Only dates which are in the range of possible dates are
considered. A date or date-time object is expected.}
}
\value{
\itemize{
\item The last of the minimum dates (\code{min_dates}) which are in the range of the
partial DTC date (\code{dtc})
\item The first of the maximum dates (\code{max_dates}) which are in the range of the
partial DTC date (\code{dtc})
\item \code{imputed_dtc} if the partial DTC date (\code{dtc}) is not in range of any of
the minimum or maximum dates.
}
}
\description{
Restrict Imputed DTC date to Minimum/Maximum Dates
}
\seealso{
\code{\link[=impute_dtc_dtm]{impute_dtc_dtm()}}, \code{\link[=impute_dtc_dt]{impute_dtc_dt()}}

Utilities used for date imputation: 
\code{\link{dt_level}()},
\code{\link{dtm_level}()},
\code{\link{get_imputation_target_date}()},
\code{\link{get_imputation_target_time}()},
\code{\link{get_partialdatetime}()},
\code{\link{restrict_imputed_dtc_dtm}()}
}
\concept{utils_impute}
\keyword{internal}
