% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_merged_ef_msrc.R
\name{flag_event}
\alias{flag_event}
\title{Create a \code{flag_event} Object}
\usage{
flag_event(dataset_name, condition = NULL, by_vars = NULL)
}
\arguments{
\item{dataset_name}{Dataset name of the dataset to be used as input for the
event. The name refers to the dataset specified for \code{source_datasets} in
\code{derive_var_merged_ef_msrc()}.

\emph{Permitted Values}: a character scalar}

\item{condition}{Condition

The condition is evaluated at the dataset referenced by \code{dataset_name}. For
all by groups where it evaluates as \code{TRUE} at least once the new variable
is set to the true value (\code{true_value}).}

\item{by_vars}{Grouping variables

If specified, the dataset is grouped by the specified variables before the
condition is evaluated. If named elements are used in \code{by_vars} like
\code{by_vars = exprs(USUBJID, EXLNKID = ECLNKID)}, the variables are renamed
after the evaluation. If the \code{by_vars} element is not specified, the
observations are grouped by the variables specified for the \code{by_vars}
argument of \code{derive_var_merged_ef_msrc()}.}
}
\description{
The \code{flag_event} object is used to define events as input for the
\code{derive_var_merged_ef_msrc()} function.
}
\seealso{
\code{\link[=derive_var_merged_ef_msrc]{derive_var_merged_ef_msrc()}}

Source Objects: 
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{death_event}},
\code{\link{event}()},
\code{\link{event_joined}()},
\code{\link{event_source}()},
\code{\link{query}()},
\code{\link{records_source}()},
\code{\link{tte_source}()}
}
\concept{source_specifications}
\keyword{source_specifications}
