library(dplyr)
# nolint start
suppress_warning(
  qs_gad7 <- tibble::tribble(
    ~QSSEQ, ~QSTESTCD, ~QSTEST, ~VISIT, ~VISITNUM, ~QSDTC, ~QSORRES,
    1L, "GAD0201", "GAD02-Feeling Nervous Anxious or On Edge", "VISIT 1", 1, "2012-11-16", "More than half the days",
    2L, "GAD0202", "GAD02-Not Able to Stop/Control Worrying", "VISIT 1", 1, "2012-11-16", "More than half the days",
    3L, "GAD0203", "GAD02-Worrying Too Much About Things", "VISIT 1", 1, "2012-11-16", "More than half the days",
    4L, "GAD0204", "GAD02-Trouble Relaxing", "VISIT 1", 1, "2012-11-16", "More than half the days",
    5L, "GAD0205", "GAD02-Being Restless Hard to Sit Still", "VISIT 1", 1, "2012-11-16", "Nearly every day",
    6L, "GAD0206", "GAD02-Becoming Easily Annoyed/Irritable", "VISIT 1", 1, "2012-11-16", "Nearly every day",
    7L, "GAD0207", "GAD02-Feel Afraid/Something Awful Happen", "VISIT 1", 1, "2012-11-16", "Several days",
    8L, "GAD0208", "GAD02-Total Score", "VISIT 1", 1, "2012-11-16", "15",
    9L, "GAD0201", "GAD02-Feeling Nervous Anxious or On Edge", "UNSCHEDULED VISIT 5.01", 501, "2013-04-15", "More than half the days",
    10L, "GAD0202", "GAD02-Not Able to Stop/Control Worrying", "UNSCHEDULED VISIT 5.01", 501, "2013-04-15", "More than half the days",
    11L, "GAD0203", "GAD02-Worrying Too Much About Things", "UNSCHEDULED VISIT 5.01", 501, "2013-04-15", "More than half the days",
    12L, "GAD0204", "GAD02-Trouble Relaxing", "UNSCHEDULED VISIT 5.01", 501, "2013-04-15", "More than half the days",
    13L, "GAD0205", "GAD02-Being Restless Hard to Sit Still", "UNSCHEDULED VISIT 5.01", 501, "2013-04-15", "Several days",
    14L, "GAD0206", "GAD02-Becoming Easily Annoyed/Irritable", "UNSCHEDULED VISIT 5.01", 501, "2013-04-15", "Nearly every day",
    15L, "GAD0207", "GAD02-Feel Afraid/Something Awful Happen", "UNSCHEDULED VISIT 5.01", 501, "2013-04-15", "More than half the days",
    16L, "GAD0208", "GAD02-Total Score", "UNSCHEDULED VISIT 5.01", 501, "2013-04-15", "14",
    17L, "GAD0201", "GAD02-Feeling Nervous Anxious or On Edge", "VISIT 6", 6, "2013-05-15", "More than half the days",
    18L, "GAD0202", "GAD02-Not Able to Stop/Control Worrying", "VISIT 6", 6, "2013-05-15", "More than half the days",
    19L, "GAD0203", "GAD02-Worrying Too Much About Things", "VISIT 6", 6, "2013-05-15", "More than half the days",
    20L, "GAD0204", "GAD02-Trouble Relaxing", "VISIT 6", 6, "2013-05-15", "More than half the days",
    21L, "GAD0205", "GAD02-Being Restless Hard to Sit Still", "VISIT 6", 6, "2013-05-15", "Several days",
    22L, "GAD0206", "GAD02-Becoming Easily Annoyed/Irritable", "VISIT 6", 6, "2013-05-15", "Nearly every day",
    23L, "GAD0207", "GAD02-Feel Afraid/Something Awful Happen", "VISIT 6", 6, "2013-05-15", "Several days",
    24L, "GAD0208", "GAD02-Total Score", "VISIT 6", 6, "2013-05-15", "13",
    25L, "GAD0201", "GAD02-Feeling Nervous Anxious or On Edge", "VISIT 12", 12, "2013-11-14", "Several days",
    26L, "GAD0202", "GAD02-Not Able to Stop/Control Worrying", "VISIT 12", 12, "2013-11-14", "Several days",
    27L, "GAD0203", "GAD02-Worrying Too Much About Things", "VISIT 12", 12, "2013-11-14", "Several days",
    28L, "GAD0204", "GAD02-Trouble Relaxing", "VISIT 12", 12, "2013-11-14", "Several days",
    29L, "GAD0205", "GAD02-Being Restless Hard to Sit Still", "VISIT 12", 12, "2013-11-14", "Several days",
    30L, "GAD0206", "GAD02-Becoming Easily Annoyed/Irritable", "VISIT 12", 12, "2013-11-14", "Several days",
    31L, "GAD0207", "GAD02-Feel Afraid/Something Awful Happen", "VISIT 12", 12, "2013-11-14", "Several days",
    32L, "GAD0208", "GAD02-Total Score", "VISIT 12", 12, "2013-11-14", "7"
  ) %>%
    mutate(
      QSCAT = "GAD-7 V2",
      QSSTRESN = recode(
        QSORRES,
        "Not at all" = 0L,
        "Several days" = 1L,
        "More than half the days" = 2L,
        "Nearly every day" = 3L,
        .default = as.integer(QSORRES)
      )
    ) %>%
    mutate(
      USUBJID = "P0001",
      .before = everything()
    ),
  regexpr = "NAs introduced by coercion"
)
qs_gdssf <- tibble::tribble(
  ~USUBJID, ~QSSEQ,                                   ~QSTEST, ~QSTESTCD,             ~VISIT, ~VISITNUM,       ~QSDTC, ~QSORRES, ~QSSTRESN,
  "P0001",      1L,               "GDS02-Satisfied With Life", "GDS0201",          "VISIT 1",         1, "2012-11-16",    "YES",        0L,
  "P0001",      2L,  "GDS02-Dropped Activities and Interests", "GDS0202",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0001",      3L,                     "GDS02-Life Is Empty", "GDS0203",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0001",      4L,                       "GDS02-Bored Often", "GDS0204",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0001",      5L,         "GDS02-Good Spirits Most of Time", "GDS0205",          "VISIT 1",         1, "2012-11-16",     "NO",        1L,
  "P0001",      6L, "GDS02-Afraid of Something Bad Happening", "GDS0206",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0001",      7L,           "GDS02-Feel Happy Most of Time", "GDS0207",          "VISIT 1",         1, "2012-11-16",     "NO",        1L,
  "P0001",      8L,               "GDS02-Often Feel Helpless", "GDS0208",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0001",      9L,               "GDS02-Prefer to Stay Home", "GDS0209",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0001",     10L,                   "GDS02-Memory Problems", "GDS0210",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0001",     11L,             "GDS02-Wonderful to Be Alive", "GDS0211",          "VISIT 1",         1, "2012-11-16",     "NO",        1L,
  "P0001",     12L,                    "GDS02-Feel Worthless", "GDS0212",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0001",     13L,               "GDS02-Feel Full of Energy", "GDS0213",          "VISIT 1",         1, "2012-11-16",    "YES",        0L,
  "P0001",     14L,                     "GDS02-Feel Hopeless", "GDS0214",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0001",     15L,   "GDS02-Most People Better Off Than You", "GDS0215",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0001",     16L,               "GDS02-Satisfied With Life", "GDS0201",          "VISIT 2",         2, "2012-12-15",    "YES",        0L,
  "P0001",     17L,  "GDS02-Dropped Activities and Interests", "GDS0202",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0001",     18L,                     "GDS02-Life Is Empty", "GDS0203",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0001",     19L,                       "GDS02-Bored Often", "GDS0204",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0001",     20L,         "GDS02-Good Spirits Most of Time", "GDS0205",          "VISIT 2",         2, "2012-12-15",     "NO",        1L,
  "P0001",     21L, "GDS02-Afraid of Something Bad Happening", "GDS0206",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0001",     22L,           "GDS02-Feel Happy Most of Time", "GDS0207",          "VISIT 2",         2, "2012-12-15",     "NO",        1L,
  "P0001",     23L,               "GDS02-Often Feel Helpless", "GDS0208",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0001",     24L,               "GDS02-Prefer to Stay Home", "GDS0209",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0001",     25L,                   "GDS02-Memory Problems", "GDS0210",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0001",     26L,             "GDS02-Wonderful to Be Alive", "GDS0211",          "VISIT 2",         2, "2012-12-15",     "NO",        1L,
  "P0001",     27L,                    "GDS02-Feel Worthless", "GDS0212",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0001",     28L,               "GDS02-Feel Full of Energy", "GDS0213",          "VISIT 2",         2, "2012-12-15",    "YES",        0L,
  "P0001",     29L,                     "GDS02-Feel Hopeless", "GDS0214",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0001",     30L,   "GDS02-Most People Better Off Than You", "GDS0215",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0001",     31L,               "GDS02-Satisfied With Life", "GDS0201", "UNSCHEDULED 2.01",       201, "2012-12-28",    "YES",        0L,
  "P0001",     32L,  "GDS02-Dropped Activities and Interests", "GDS0202", "UNSCHEDULED 2.01",       201, "2012-12-28",     "NO",        0L,
  "P0001",     33L,                     "GDS02-Life Is Empty", "GDS0203", "UNSCHEDULED 2.01",       201, "2012-12-28",    "YES",        1L,
  "P0001",     34L,                       "GDS02-Bored Often", "GDS0204", "UNSCHEDULED 2.01",       201, "2012-12-28",    "YES",        1L,
  "P0001",     35L,         "GDS02-Good Spirits Most of Time", "GDS0205", "UNSCHEDULED 2.01",       201, "2012-12-28",     "NO",        1L,
  "P0001",     36L, "GDS02-Afraid of Something Bad Happening", "GDS0206", "UNSCHEDULED 2.01",       201, "2012-12-28",    "YES",        1L,
  "P0001",     37L,           "GDS02-Feel Happy Most of Time", "GDS0207", "UNSCHEDULED 2.01",       201, "2012-12-28",     "NO",        0L,
  "P0001",     38L,               "GDS02-Often Feel Helpless", "GDS0208", "UNSCHEDULED 2.01",       201, "2012-12-28",    "YES",        1L,
  "P0001",     39L,               "GDS02-Prefer to Stay Home", "GDS0209", "UNSCHEDULED 2.01",       201, "2012-12-28",     "NO",        0L,
  "P0001",     40L,                   "GDS02-Memory Problems", "GDS0210", "UNSCHEDULED 2.01",       201, "2012-12-28",     "NO",        0L,
  "P0001",     41L,             "GDS02-Wonderful to Be Alive", "GDS0211", "UNSCHEDULED 2.01",       201, "2012-12-28",     "NO",        1L,
  "P0001",     42L,                    "GDS02-Feel Worthless", "GDS0212", "UNSCHEDULED 2.01",       201, "2012-12-28",    "YES",        1L,
  "P0001",     43L,               "GDS02-Feel Full of Energy", "GDS0213", "UNSCHEDULED 2.01",       201, "2012-12-28",    "YES",        0L,
  "P0001",     44L,                     "GDS02-Feel Hopeless", "GDS0214", "UNSCHEDULED 2.01",       201, "2012-12-28",    "YES",        1L,
  "P0001",     45L,   "GDS02-Most People Better Off Than You", "GDS0215", "UNSCHEDULED 2.01",       201, "2012-12-28",     "NO",        0L,
  "P0001",     46L,               "GDS02-Satisfied With Life", "GDS0201",          "VISIT 3",         3, "2013-01-12",       NA,        NA,
  "P0001",     47L,  "GDS02-Dropped Activities and Interests", "GDS0202",          "VISIT 3",         3, "2013-01-12",       NA,        NA,
  "P0001",     48L,                     "GDS02-Life Is Empty", "GDS0203",          "VISIT 3",         3, "2013-01-12",     "NO",        0L,
  "P0001",     49L,                       "GDS02-Bored Often", "GDS0204",          "VISIT 3",         3, "2013-01-12",     "NO",        0L,
  "P0001",     50L,         "GDS02-Good Spirits Most of Time", "GDS0205",          "VISIT 3",         3, "2013-01-12",    "YES",        0L,
  "P0001",     51L, "GDS02-Afraid of Something Bad Happening", "GDS0206",          "VISIT 3",         3, "2013-01-12",    "YES",        1L,
  "P0001",     52L,           "GDS02-Feel Happy Most of Time", "GDS0207",          "VISIT 3",         3, "2013-01-12",     "NO",        1L,
  "P0001",     53L,               "GDS02-Often Feel Helpless", "GDS0208",          "VISIT 3",         3, "2013-01-12",    "YES",        1L,
  "P0001",     54L,               "GDS02-Prefer to Stay Home", "GDS0209",          "VISIT 3",         3, "2013-01-12",     "NO",        0L,
  "P0001",     55L,                   "GDS02-Memory Problems", "GDS0210",          "VISIT 3",         3, "2013-01-12",     "NO",        0L,
  "P0001",     56L,             "GDS02-Wonderful to Be Alive", "GDS0211",          "VISIT 3",         3, "2013-01-12",     "NO",        1L,
  "P0001",     57L,                    "GDS02-Feel Worthless", "GDS0212",          "VISIT 3",         3, "2013-01-12",    "YES",        1L,
  "P0001",     58L,               "GDS02-Feel Full of Energy", "GDS0213",          "VISIT 3",         3, "2013-01-12",    "YES",        0L,
  "P0001",     59L,                     "GDS02-Feel Hopeless", "GDS0214",          "VISIT 3",         3, "2013-01-12",    "YES",        1L,
  "P0001",     60L,   "GDS02-Most People Better Off Than You", "GDS0215",          "VISIT 3",         3, "2013-01-12",     "NO",        0L,
  "P0001",     61L,               "GDS02-Satisfied With Life", "GDS0201",          "VISIT 4",         4, "2013-02-13",    "YES",        0L,
  "P0001",     62L,  "GDS02-Dropped Activities and Interests", "GDS0202",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0001",     63L,                     "GDS02-Life Is Empty", "GDS0203",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0001",     64L,                       "GDS02-Bored Often", "GDS0204",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0001",     65L,         "GDS02-Good Spirits Most of Time", "GDS0205",          "VISIT 4",         4, "2013-02-13",    "YES",        0L,
  "P0001",     66L, "GDS02-Afraid of Something Bad Happening", "GDS0206",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0001",     67L,           "GDS02-Feel Happy Most of Time", "GDS0207",          "VISIT 4",         4, "2013-02-13",     "NO",        1L,
  "P0001",     68L,               "GDS02-Often Feel Helpless", "GDS0208",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0001",     69L,               "GDS02-Prefer to Stay Home", "GDS0209",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0001",     70L,                   "GDS02-Memory Problems", "GDS0210",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0001",     71L,             "GDS02-Wonderful to Be Alive", "GDS0211",          "VISIT 4",         4, "2013-02-13",     "NO",        1L,
  "P0001",     72L,                    "GDS02-Feel Worthless", "GDS0212",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0001",     73L,               "GDS02-Feel Full of Energy", "GDS0213",          "VISIT 4",         4, "2013-02-13",    "YES",        0L,
  "P0001",     74L,                     "GDS02-Feel Hopeless", "GDS0214",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0001",     75L,   "GDS02-Most People Better Off Than You", "GDS0215",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0002",      1L,               "GDS02-Satisfied With Life", "GDS0201",          "VISIT 1",         1, "2012-11-16",    "YES",        0L,
  "P0002",      2L,  "GDS02-Dropped Activities and Interests", "GDS0202",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0002",      3L,                     "GDS02-Life Is Empty", "GDS0203",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0002",      4L,                       "GDS02-Bored Often", "GDS0204",          "VISIT 1",         1, "2012-11-16",    "YES",        1L,
  "P0002",      5L,         "GDS02-Good Spirits Most of Time", "GDS0205",          "VISIT 1",         1, "2012-11-16",     "NO",        1L,
  "P0002",      6L, "GDS02-Afraid of Something Bad Happening", "GDS0206",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0002",      7L,           "GDS02-Feel Happy Most of Time", "GDS0207",          "VISIT 1",         1, "2012-11-16",     "NO",        1L,
  "P0002",      8L,               "GDS02-Often Feel Helpless", "GDS0208",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0002",      9L,               "GDS02-Prefer to Stay Home", "GDS0209",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0002",     10L,                   "GDS02-Memory Problems", "GDS0210",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0002",     11L,             "GDS02-Wonderful to Be Alive", "GDS0211",          "VISIT 1",         1, "2012-11-16",    "YES",        0L,
  "P0002",     12L,                    "GDS02-Feel Worthless", "GDS0212",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0002",     13L,               "GDS02-Feel Full of Energy", "GDS0213",          "VISIT 1",         1, "2012-11-16",    "YES",        0L,
  "P0002",     14L,                     "GDS02-Feel Hopeless", "GDS0214",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0002",     15L,   "GDS02-Most People Better Off Than You", "GDS0215",          "VISIT 1",         1, "2012-11-16",     "NO",        0L,
  "P0002",     16L,               "GDS02-Satisfied With Life", "GDS0201",          "VISIT 2",         2, "2012-12-15",    "YES",        0L,
  "P0002",     17L,  "GDS02-Dropped Activities and Interests", "GDS0202",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0002",     18L,                     "GDS02-Life Is Empty", "GDS0203",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0002",     19L,                       "GDS02-Bored Often", "GDS0204",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0002",     20L,         "GDS02-Good Spirits Most of Time", "GDS0205",          "VISIT 2",         2, "2012-12-15",     "NO",        1L,
  "P0002",     21L, "GDS02-Afraid of Something Bad Happening", "GDS0206",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0002",     22L,           "GDS02-Feel Happy Most of Time", "GDS0207",          "VISIT 2",         2, "2012-12-15",     "NO",        1L,
  "P0002",     23L,               "GDS02-Often Feel Helpless", "GDS0208",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0002",     24L,               "GDS02-Prefer to Stay Home", "GDS0209",          "VISIT 2",         2, "2012-12-15",    "YES",        1L,
  "P0002",     25L,                   "GDS02-Memory Problems", "GDS0210",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0002",     26L,             "GDS02-Wonderful to Be Alive", "GDS0211",          "VISIT 2",         2, "2012-12-15",    "YES",        0L,
  "P0002",     27L,                    "GDS02-Feel Worthless", "GDS0212",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0002",     28L,               "GDS02-Feel Full of Energy", "GDS0213",          "VISIT 2",         2, "2012-12-15",    "YES",        0L,
  "P0002",     29L,                     "GDS02-Feel Hopeless", "GDS0214",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0002",     30L,   "GDS02-Most People Better Off Than You", "GDS0215",          "VISIT 2",         2, "2012-12-15",     "NO",        0L,
  "P0002",     46L,               "GDS02-Satisfied With Life", "GDS0201",          "VISIT 4",         4, "2013-02-13",     "NO",        1L,
  "P0002",     47L,  "GDS02-Dropped Activities and Interests", "GDS0202",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0002",     48L,                     "GDS02-Life Is Empty", "GDS0203",          "VISIT 4",         4, "2013-02-13",     "NO",        0L,
  "P0002",     49L,                       "GDS02-Bored Often", "GDS0204",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0002",     50L,         "GDS02-Good Spirits Most of Time", "GDS0205",          "VISIT 4",         4, "2013-02-13",     "NO",        1L,
  "P0002",     51L, "GDS02-Afraid of Something Bad Happening", "GDS0206",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0002",     52L,           "GDS02-Feel Happy Most of Time", "GDS0207",          "VISIT 4",         4, "2013-02-13",     "NO",        1L,
  "P0002",     53L,               "GDS02-Often Feel Helpless", "GDS0208",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0002",     54L,               "GDS02-Prefer to Stay Home", "GDS0209",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0002",     55L,                   "GDS02-Memory Problems", "GDS0210",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0002",     56L,             "GDS02-Wonderful to Be Alive", "GDS0211",          "VISIT 4",         4, "2013-02-13",     "NO",        1L,
  "P0002",     57L,                    "GDS02-Feel Worthless", "GDS0212",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0002",     58L,               "GDS02-Feel Full of Energy", "GDS0213",          "VISIT 4",         4, "2013-02-13",     "NO",        1L,
  "P0002",     59L,                     "GDS02-Feel Hopeless", "GDS0214",          "VISIT 4",         4, "2013-02-13",    "YES",        1L,
  "P0002",     60L,   "GDS02-Most People Better Off Than You", "GDS0215",          "VISIT 4",         4, "2013-02-13",     "NO",        0L
) %>%
  mutate(QSCAT = "GDS SHORT FORM")

qs_sp <- tibble::tribble(
  ~USUBJID, ~QSTEST,                                 ~QSTESTCD, ~VISIT,    ~VISITNUM, ~QSDTC,       ~QSORRES, ~QSSTRESN,
  "P0001",  "SP01-No sleep at all",                  "SP0101",  "VISIT 1",         1, "2012-11-16", "NO",            0L,
  "P0001",  "SP01-Waking up more than three times",  "SP0102",  "VISIT 1",         1, "2012-11-16", "NO",            0L,
  "P0001",  "SP01-More than 30 mins to fall asleep", "SP0103",  "VISIT 1",         1, "2012-11-16", "YES",           1L,
  "P0001",  "SP01-No sleep at all",                  "SP0101",  "VISIT 2",         2, "2012-12-15", "NO",            0L,
  "P0001",  "SP01-Waking up more than three times",  "SP0102",  "VISIT 2",         2, "2012-12-15", "NO",            0L,
  "P0001",  "SP01-More than 30 mins to fall asleep", "SP0103",  "VISIT 2",         2, "2012-12-15", "NO",            0L,
  "P0001",  "SP01-No sleep at all",                  "SP0101",  "VISIT 4",         4, "2013-02-13", "NO",            0L,
  "P0001",  "SP01-Waking up more than three times",  "SP0102",  "VISIT 4",         4, "2013-02-13", "YES",           1L,
  "P0001",  "SP01-More than 30 mins to fall asleep", "SP0103",  "VISIT 4",         4, "2013-02-13", "YES",           1L,
) %>%
  mutate(
    QSSEQ = row_number(),
    QSCAT = "SLEEPING PROBLEMS",
    .after = USUBJID
  )

# nolint end
example_qs <- bind_rows(qs_gad7, qs_gdssf, qs_sp) %>%
  mutate(
    STUDYID = "STUDYX",
    .before = everything()
  )

save(example_qs, file = file.path("data", "example_qs.rda"), compress = "bzip2")
