% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_dthcaus.R
\name{dthcaus_source}
\alias{dthcaus_source}
\title{Create a \code{dthcaus_source} Object}
\usage{
dthcaus_source(
  dataset_name,
  filter,
  date,
  order = NULL,
  mode = "first",
  dthcaus,
  traceability_vars = NULL
)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the death cause.}

\item{filter}{An expression used for filtering \code{dataset}.}

\item{date}{A date or datetime variable to be used for sorting \code{dataset}.}

\item{order}{Sort order

Additional variables to be used for sorting the \code{dataset} which is ordered by the
\code{date} and \code{order}. Can be used to avoid duplicate record warning.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: list of variables or \verb{desc(<variable>)} function calls
created by \code{vars()}, e.g., \code{vars(ADT, desc(AVAL))} or \code{NULL}}

\item{mode}{One of \code{"first"} or \code{"last"}.
Either the \code{"first"} or \code{"last"} observation is preserved from the \code{dataset}
which is ordered by \code{date}.}

\item{dthcaus}{A variable name or a string literal --- if a variable name, e.g., \code{AEDECOD},
it is the variable in the source dataset to be used to assign values to
\code{DTHCAUS}; if a string literal, e.g. \code{"Adverse Event"}, it is the fixed value
to be assigned to \code{DTHCAUS}.}

\item{traceability_vars}{A named list returned by \code{\link[=vars]{vars()}} listing the traceability variables,
e.g. \code{vars(DTHDOM = "DS", DTHSEQ = DSSEQ)}.
The left-hand side (names of the list elements) gives the names of the traceability variables
in the returned dataset.
The right-hand side (values of the list elements) gives the values of the traceability variables
in the returned dataset.
These can be either strings or symbols referring to existing variables.}
}
\value{
An object of class "dthcaus_source".
}
\description{
Create a \code{dthcaus_source} Object
}
\examples{
# Deaths sourced from AE
src_ae <- dthcaus_source(
  dataset_name = "ae",
  filter = AEOUT == "FATAL",
  date = AEDTHDT,
  mode = "first",
  dthcaus = AEDECOD
)

# Deaths sourced from DS
src_ds <- dthcaus_source(
  dataset_name = "ds",
  filter = DSDECOD == "DEATH",
  date = DSSTDT,
  mode = "first",
  dthcaus = DSTERM
)
}
\seealso{
\code{\link[=derive_var_dthcaus]{derive_var_dthcaus()}}

Source Specifications: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_terms}()},
\code{\link{assert_valid_queries}()},
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{date_source}()},
\code{\link{death_event}},
\code{\link{event_source}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{query}()},
\code{\link{sdg_select}()},
\code{\link{smq_select}()},
\code{\link{tte_source}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\author{
Shimeng Huang
}
\concept{source_specifications}
\keyword{source_specifications}
