% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warnings.R
\name{warn_if_inconsistent_list}
\alias{warn_if_inconsistent_list}
\title{Warn If Two Lists are Inconsistent}
\usage{
warn_if_inconsistent_list(base, compare, list_name, i = 2)
}
\arguments{
\item{base}{A named list}

\item{compare}{A named list}

\item{list_name}{A string
the name of the list}

\item{i}{the index id to compare the 2 lists}
}
\value{
a \code{warning} if the 2 lists have different names or length
}
\description{
Checks if two list inputs have the same names and same number of elements and
issues a warning otherwise.
}
\examples{
# no warning
warn_if_inconsistent_list(
  base = vars(DTHDOM = "DM", DTHSEQ = DMSEQ),
  compare = vars(DTHDOM = "DM", DTHSEQ = DMSEQ),
  list_name = "Test"
)
# warning
warn_if_inconsistent_list(
  base = vars(DTHDOM = "DM", DTHSEQ = DMSEQ, DTHVAR = "text"),
  compare = vars(DTHDOM = "DM", DTHSEQ = DMSEQ),
  list_name = "Test"
)
}
\author{
Samia Kabi
}
\keyword{warning}
