% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_date_vars.R
\name{convert_dtc_to_dt}
\alias{convert_dtc_to_dt}
\title{Convert a Date Character Vector into a Date Object}
\usage{
convert_dtc_to_dt(
  dtc,
  date_imputation = NULL,
  min_dates = NULL,
  max_dates = NULL,
  preserve = FALSE
)
}
\arguments{
\item{dtc}{The --DTC date to convert.

A character date is expected in a format like yyyy-mm-dd or yyyy-mm-ddThh:mm:ss.
A partial date will return a NA date and a warning will be issued:
'All formats failed to parse. No formats found.'.
Note: you can use impute_dtc function to build a complete date.}

\item{date_imputation}{The value to impute the day/month when a datepart is
missing.

If \code{NULL}: no date imputation is performed and partial dates are returned as
missing.

Otherwise, a character value is expected, either as a
\itemize{
\item format with month and day specified as \code{"mm-dd"}: e.g. \code{"06-15"} for the 15th
of June,
\item or as a keyword: \code{"FIRST"}, \code{"MID"}, \code{"LAST"} to impute to the first/mid/last
day/month.
}

Default is \code{NULL}.}

\item{min_dates}{Minimum dates

A list of dates is expected. It is ensured that the imputed date is not
before any of the specified dates, e.g., that the imputed adverse event start
date is not before the first treatment date. Only dates which are in the
range of possible dates of the \code{dtc} value are considered. The possible dates
are defined by the missing parts of the \code{dtc} date (see example below). This
ensures that the non-missing parts of the \code{dtc} date are not changed. For
example\preformatted{impute_dtc(
  "2020-11",
  min_dates = list(
    ymd_hms("2020-12-06T12:12:12"),
    ymd_hms("2020-11-11T11:11:11")
   ),
  date_imputation = "first"
)
}

returns \code{"2020-11-11T11:11:11"} because the possible dates for \code{"2020-11"}
range from \code{"2020-11-01T00:00:00"} to \code{"2020-11-30T23:59:59"}. Therefore
\code{"2020-12-06T12:12:12"} is ignored. Returning \code{"2020-12-06T12:12:12"} would
have changed the month although it is not missing (in the \code{dtc} date).}

\item{max_dates}{Maximum dates

A list of dates is expected. It is ensured that the imputed date is not after
any of the specified dates, e.g., that the imputed date is not after the data
cut off date. Only dates which are in the range of possible dates are
considered.}

\item{preserve}{Preserve day if month is missing and day is present

For example \code{"2019---07"} would return \verb{"2019-06-07} if \code{preserve = TRUE}
(and \code{date_imputation = "MID"}).

Permitted Values: \code{TRUE}, \code{FALSE}

Default: \code{FALSE}}
}
\value{
a date object
}
\description{
Convert a date character vector (usually '--DTC') into a Date vector (usually '--DT').
}
\examples{
convert_dtc_to_dt("2019-07-18")
convert_dtc_to_dt("2019-07")
}
\author{
Samia Kabi
}
\keyword{computation}
\keyword{timing}
