% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_vars}
\alias{assert_vars}
\title{Is an Argument a List of Variables?}
\usage{
assert_vars(arg, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a list of variables created using \code{vars()}
and returns the input invisibly otherwise.
}
\description{
Checks if an argument is a valid list of variables created using \code{vars()}
}
\examples{
example_fun <- function(by_vars) {
  assert_vars(by_vars)
}

example_fun(vars(USUBJID, PARAMCD))

try(example_fun(exprs(USUBJID, PARAMCD)))

try(example_fun(c("USUBJID", "PARAMCD", "VISIT")))

try(example_fun(vars(USUBJID, toupper(PARAMCD), desc(AVAL))))
}
\author{
Samia Kabi
}
\keyword{assertion}
