% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_trial.R
\name{setup_trial_norm}
\alias{setup_trial_norm}
\title{Setup a trial specification using a continuous, normally distributed outcome}
\usage{
setup_trial_norm(
  arms,
  true_ys,
  sds,
  start_probs = NULL,
  fixed_probs = NULL,
  min_probs = rep(NA, length(arms)),
  max_probs = rep(NA, length(arms)),
  data_looks = NULL,
  max_n = NULL,
  look_after_every = NULL,
  randomised_at_looks = NULL,
  control = NULL,
  control_prob_fixed = NULL,
  inferiority = 0.01,
  superiority = 0.99,
  equivalence_prob = NULL,
  equivalence_diff = NULL,
  equivalence_only_first = NULL,
  futility_prob = NULL,
  futility_diff = NULL,
  futility_only_first = NULL,
  highest_is_best = FALSE,
  soften_power = 1,
  cri_width = 0.95,
  n_draws = 5000,
  robust = FALSE,
  description = "generic normally distributed outcome trial"
)
}
\arguments{
\item{arms}{character vector with unique names for the trial arms.}

\item{true_ys}{numeric vector, simulated means of the outcome in all trial
\code{arms}.}

\item{sds}{numeric vector, true standard deviations (must be \verb{> 0}) of the
outcome in all trial \code{arms}.}

\item{start_probs}{numeric vector, allocation probabilities for each arm at
the beginning of the trial. The default (\code{NULL}) automatically generates
equal randomisation probabilities for each arm.}

\item{fixed_probs}{numeric vector, fixed allocation probabilities for each
arm. Must be either a numeric vector with \code{NA} for arms without fixed
probabilities and values between \code{0} and \code{1} for the other arms or \code{NULL}
(default), if adaptive randomisation is used for all arms or if one of the
special settings (\code{"sqrt-based"}, \code{"sqrt-based start"},
\code{"sqrt-based fixed"}, or \code{"match"}) is specified for \code{control_prob_fixed}
(described below).}

\item{min_probs}{numeric vector, lower threshold for adaptive allocation
probabilities; lower probabilities will be rounded up to these values. Must
be \code{NA} (default for all arms) if no lower threshold is wanted and for arms
using fixed allocation probabilities.}

\item{max_probs}{numeric vector, upper threshold for adaptive allocation
probabilities; higher probabilities will be rounded down to these values.
Must be \code{NA} (default for all arms) if no threshold is wanted and for arms
using fixed allocation probabilities.}

\item{data_looks}{vector of increasing integers, specifies when to conduct
adaptive analyses (= the total number of patients with available outcome
data at each adaptive analysis). The last number in the vector represents
the final adaptive analysis, i.e., the final analysis where superiority,
inferiority, practical equivalence, or futility can be claimed.
Instead of specifying \code{data_looks}, the \code{max_n} and \code{look_after_every}
arguments can be used in combination (in which case \code{data_looks} must be
\code{NULL}, the default value).}

\item{max_n}{single integer, number of patients with available outcome data
at the last possible adaptive analysis (defaults to \code{NULL}).
Must only be specified if \code{data_looks} is \code{NULL}. Requires specification of
the \code{look_after_every} argument.}

\item{look_after_every}{single integer, specified together with \code{max_n}.
Adaptive analyses will be conducted after every \code{look_after_every}
patients have available outcome data, and at the total sample size as
specified by \code{max_n} (\code{max_n} does not need to be a multiple of
\code{look_after_every}). If specified, \code{data_looks} must be \code{NULL} (default).}

\item{randomised_at_looks}{vector of increasing integers or \code{NULL},
specifying the number of patients randomised at the time of each adaptive
analysis, with new patients randomised using the current allocation
probabilities at said analysis.
If \code{NULL} (the default), the number of patients randomised at each analysis
will match the number of patients with available outcome data at said
analysis, as specified by \code{data_looks} or \code{max_n} and \code{look_after_every},
i.e., outcome data will be available immediately after randomisation for
all patients.\cr
If not \code{NULL}, the vector must be of the same length as the number of
adaptive analyses specified by \code{data_looks} or \code{max_n} and
\code{look_after_every}, and all values must be larger than or equal to the
number of patients with available outcome data at each analysis.}

\item{control}{single character string, name of one of the \code{arms} or \code{NULL}
(default). If specified, this arm will serve as a common control arm, to
which all other arms will be compared and the
inferiority/superiority/equivalence thresholds (see below) will be for
those comparisons. See \code{\link[=setup_trial]{setup_trial()}} \strong{Details} for information on
behaviour with respect to these comparisons.}

\item{control_prob_fixed}{if a common \code{control} arm is specified, this can
be set \code{NULL} (the default), in which case the control arm allocation
probability will not be fixed if control arms change (the allocation
probability for the first control arm may still be fixed using
\code{fixed_probs}). If not \code{NULL}, a vector of probabilities of either length
\code{1} or \verb{number of arms - 1} can be provided, or one of the special
arguments \code{"sqrt-based"}, \code{"sqrt-based start"}, \code{"sqrt-based fixed"} or
\code{"match"}. See \code{\link[=setup_trial]{setup_trial()}} \strong{Details} for details on how this affects
trial behaviour.}

\item{inferiority}{single numeric value or vector of numeric values of the
same length as the maximum number of possible adaptive analyses, specifying
the probability threshold(s) for inferiority (default is \code{0.01}). All
values must be \verb{>= 0} and \verb{<= 1}, and if multiple values are supplied, no
values may be lower than the preceding value. If a common \code{control}is not
used, all values must be \verb{< 1 / number of arms}. An arm will be considered
inferior and dropped if the probability that it is best (when comparing all
arms) or better than the control arm (when a common \code{control} is used)
drops below the inferiority threshold at an adaptive analysis.}

\item{superiority}{single numeric value or vector of numeric values of the
same length as the maximum number of possible adaptive analyses, specifying
the probability threshold(s) for superiority (default is \code{0.99}). All
values must be \verb{>= 0} and \verb{<= 1}, and if multiple values are supplied, no
values may be higher than the preceding value. If the probability that an
arm is best (when comparing all arms) or better than the control arm (when
a common \code{control} is used) exceeds the superiority threshold at an
adaptive analysis, said arm will be declared the winner and the trial will
be stopped (if no common \code{control} is used or if the last comparator is
dropped in a design with a common control) \emph{or} become the new control and
the trial will continue (if a common control is specified).}

\item{equivalence_prob}{single numeric value, vector of numeric values of the
same length as the maximum number of possible adaptive analyses or \code{NULL}
(default, corresponding to no equivalence assessment), specifying the
probability threshold(s) for equivalence. If not \code{NULL}, all values must be
\verb{> 0} and \verb{<= 1}, and if multiple values are supplied, no value may be
higher than the preceding value. If not \code{NULL}, arms will be dropped for
equivalence if the probability of either \emph{(a)} equivalence compared to a
common \code{control} or \emph{(b)} equivalence between all arms remaining (designs
without a common \code{control}) exceeds the equivalence threshold at an
adaptive analysis. Requires specification of \code{equivalence_diff} and
\code{equivalence_only_first}.}

\item{equivalence_diff}{single numeric value (\verb{> 0}) or \code{NULL} (default,
corresponding to no equivalence assessment). If a numeric value is
specified, estimated absolute differences smaller than this threshold will
be considered equivalent. For designs with a common \code{control} arm, the
differences between each non-control arm and the \code{control} arm is used, and
for trials without a common \code{control} arm, the difference between the
highest and lowest estimated outcome rates are used and the trial is only
stopped for equivalence if all remaining arms are equivalent.}

\item{equivalence_only_first}{single logical in trial specifications where
\code{equivalence_prob} and \code{equivalence_diff} are specified and a common
\code{control} arm is included, otherwise \code{NULL} (default). If a common
\code{control} arm is used, this specifies whether equivalence will only be
assessed for the first control (if \code{TRUE}) or also for subsequent \code{control}
arms (if \code{FALSE}) if one arm is superior to the first control and becomes
the new control.}

\item{futility_prob}{single numeric value, vector of numeric values of the
same length as the maximum number of possible adaptive analyses or \code{NULL}
(default, corresponding to no futility assessment), specifying the
probability threshold(s) for futility. All values must be \verb{> 0} and \verb{<= 1},
and if multiple values are supplied, no value may be higher than the
preceding value. If not \code{NULL}, arms will be dropped for futility if
the probability for futility compared to the common \code{control} exceeds the
futility threshold at an adaptive analysis. Requires a common \code{control}
arm (otherwise this argument must be \code{NULL}), specification of
\code{futility_diff}, and \code{futility_only_first}.}

\item{futility_diff}{single numeric value (\verb{> 0}) or \code{NULL} (default,
corresponding to no futility assessment). If a numeric value is specified,
estimated differences below this threshold in the \emph{beneficial} direction
(as specified in \code{highest_is_best}) will be considered futile when
assessing futility in designs with a common \code{control} arm. If only 1 arm
remains after dropping arms for futility, the trial will be stopped without
declaring the last arm superior.}

\item{futility_only_first}{single logical in trial specifications designs
where \code{futility_prob} and \code{futility_diff} are specified, otherwise \code{NULL}
(default and required in designs without a common \code{control} arm).
Specifies whether futility will only be assessed against the first
\code{control} (if \code{TRUE}) or also for subsequent control arms (if \code{FALSE}) if
one arm is superior to the first control and becomes the new control.}

\item{highest_is_best}{single logical, specifies whether larger estimates of
the outcome are favourable or not; defaults to \code{FALSE}, corresponding to,
e.g., an undesirable binary outcomes (e.g., mortality) or a continuous
outcome where lower numbers are preferred (e.g., hospital length of stay).}

\item{soften_power}{either a single numeric value or a numeric vector of
exactly the same length as the maximum number of looks/adaptive analyses.
Values must be between \code{0} and \code{1} (default); if \verb{< 1}, then re-allocated
non-fixed allocation probabilities are all raised to this power (followed
by rescaling to sum to \code{1}) to make adaptive allocation probabilities
less extreme, in turn used to redistribute remaining probability while
respecting limits when defined by \code{min_probs} and/or \code{max_probs}. If \code{1},
then no \emph{softening} is applied.}

\item{cri_width}{single numeric \verb{>= 0} and \verb{< 1}, the width of the
percentile-based credible intervals used when summarising individual trial
results. Defaults to \code{0.95}, corresponding to 95\% credible intervals.}

\item{n_draws}{single integer, the number of draws from the posterior
distributions for each arm used when running the trial. Defaults to
\code{5000}; can be reduced for a speed gain (at the potential loss of stability
of results if too low) or increased for increased precision (increasing
simulation time). Values \verb{< 100} are not allowed and values \verb{< 1000} are
not recommended and warned against.}

\item{robust}{single logical, if \code{TRUE} (default) the medians and median
absolute deviations (scaled to be comparable to the standard deviation for
normal distributions; MAD_SDs, see \code{\link[stats:mad]{stats::mad()}}) are used to summarise
the posterior distributions; if \code{FALSE}, the means and standard deviations
(SDs) are used instead (slightly faster, but may be less appropriate for
posteriors skewed on the natural scale).}

\item{description}{character string, default is
\code{"generic normally distributed outcome trial"}. See arguments of
\code{\link[=setup_trial]{setup_trial()}}.}
}
\value{
A \code{trial_spec} object used to run simulations by \code{\link[=run_trial]{run_trial()}} or
\code{\link[=run_trials]{run_trials()}}. The output is essentially a list containing the input
values (some combined in a \code{data.frame} called \code{trial_arms}), but its class
signals that these inputs have been validated and inappropriate
combinations and settings have been ruled out. Also contains \code{best_arm},
holding the arm(s) with the best value(s) in \code{true_ys}. Use \code{str()} to
peruse the actual content of the returned object.
}
\description{
Specifies the design of an adaptive trial with a continuous, normally
distributed outcome and validates all inputs. Uses normally distributed
posterior distributions for the mean values in each
trial arm; technically, no priors are used (as using \emph{normal-normal}
conjugate prior models with extremely wide or uniform priors gives similar
results for these simple, unadjusted estimates). This corresponds to the use
of improper, flat priors, although not explicitly specified as such. Use
\code{\link[=calibrate_trial]{calibrate_trial()}} to calibrate the trial specification to obtain a specific
value for a certain performance metric (e.g., the Bayesian type 1 error
rate). Use \code{\link[=run_trial]{run_trial()}} or \code{\link[=run_trials]{run_trials()}} to conduct single/multiple
simulations of the specified trial, respectively.\cr
\strong{Note:} \code{add_info} as specified in \code{\link[=setup_trial]{setup_trial()}} is set to the arms and
standard deviations used for trials specified using this function.\cr
\strong{Further details:} please see \code{\link[=setup_trial]{setup_trial()}}. See \code{\link[=setup_trial_binom]{setup_trial_binom()}}
for simplified setup of trials with binomially distributed binary outcomes.
\cr
For additional trial specification examples, see the the
\strong{Basic examples} vignette
(\code{vignette("Basic-examples", package = "adaptr")}) and the
\strong{Advanced example} vignette
(\code{vignette("Advanced-example", package = "adaptr")}).
}
\details{
Because the posteriors used in this type of trial (with a generic,
continuous, normally distributed outcome) are by definition normally
distributed, \code{FALSE} is used as the default value for the \code{robust} argument.
}
\examples{
# Setup a trial specification using a continuous, normally distributed, desirable outcome
norm_trial <- setup_trial_norm(
  arms = c("Control", "New A", "New B", "New C"),
  true_ys = c(15, 20, 14, 13),
  sds = c(2, 2.5, 1.9, 1.8), # SDs in each arm
  max_n = 500,
  look_after_every = 50,
  control = "Control", # Common control arm
  # Square-root-based, fixed control group allocation ratios
  control_prob_fixed = "sqrt-based fixed",
  # Desirable outcome
  highest_is_best = TRUE,
  soften_power = 0.5 # Limit extreme allocation ratios
)

# Print using 3 digits for probabilities
print(norm_trial, prob_digits = 3)

}
