% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ys_and_draws.R
\name{get_draws_generic}
\alias{get_draws_generic}
\title{Generic documentation for get_draws_* functions}
\arguments{
\item{arms}{character vector, \strong{currently active} \code{arms} as specified in
\code{\link[=setup_trial]{setup_trial()}} / \code{\link[=setup_trial_binom]{setup_trial_binom()}} / \code{\link[=setup_trial_norm]{setup_trial_norm()}}.}

\item{allocs}{character vector, allocations of all patients (including
allocations to \strong{currently inactive} \code{arms}).}

\item{ys}{numeric vector, outcomes of all patients in the same order
as \code{alloc} (including outcomes of patients in \strong{currently inactive}
\code{arms}).}

\item{control}{unused argument in the built-in functions for
\code{\link[=setup_trial_binom]{setup_trial_binom()}} and \link{setup_trial_norm}, but required as this
argument is supplied by the \code{\link[=run_trial]{run_trial()}} function, and may be used in
user-defined functions used to generate posterior draws.}

\item{n_draws}{single integer, number of posterior draws.}
}
\value{
A \code{matrix} (with numeric values) with \code{length(arms)} columns and
\code{n_draws} rows, with \code{arms} as column names.
}
\description{
Used internally. See the \code{\link[=setup_trial]{setup_trial()}} function documentation for
additional details on how to specify functions to generate posterior draws.
}
\keyword{internal}
