% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullSp.R
\name{nullSp}
\alias{nullSp}
\title{Finding null space of linear operator}
\usage{
nullSp(A)
}
\arguments{
\item{A}{m by n matrix}
}
\value{
\code{nullSp} returns a matrix whose columns span the nullspace of A.
}
\description{
Finds the null space of a linear operator A in \eqn{R^{n \times m}}{R^(n by m)}.
The null space is given as a matrix, where the columns form an orthonormal basis
for the nullspace. This function emulates the null function in matlab, it
works exactly the same, but the basis vectors may be different, i.e. rotated.
}
\details{
This function is used by other functions and should only be called explicitly for
debugging purposes.
}
\seealso{
Alternative \code{\link[MASS]{Null}} function in MASS package.
}
\keyword{internal}
