% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abn-infotheo.R
\name{miData}
\alias{miData}
\title{Empirical Estimation of the Entropy from a Table of Counts}
\usage{
miData(freqs.table, method = c("mi.raw", "mi.raw.pc"))
}
\arguments{
\item{freqs.table}{a table of counts.}

\item{method}{a character determining if the Mutual Information should be normalized.}
}
\value{
Mutual information estimate.
}
\description{
This function empirically estimates the Mutual Information from a table of counts using the observed frequencies.
}
\details{
The mutual information estimation is computed from the observed frequencies through a plugin estimator based on entropy.

The plugin estimator is \deqn{I(X, Y) = H (X) + H(Y) - H(X, Y)}, where \deqn{H()} is the entropy computed with \code{\link{entropyData}}.
}
\examples{
## Generate random variable
Y <- rnorm(n = 100, mean = 0, sd = 2)
X <- rnorm(n = 100, mean = 5, sd = 2)

dist <- list(Y="gaussian", X="gaussian")

miData(discretization(data.df = cbind(X,Y), data.dists = dist,
                      discretization.method = "fd", nb.states = FALSE),
                      method = "mi.raw")
}
\references{
Cover, Thomas M, and Joy A Thomas. (2012). "Elements of Information Theory". John Wiley & Sons.
}
\seealso{
\code{\link{discretization}}
}
\keyword{utilities}
