% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Cichlids}
\alias{Cichlids}
\title{Cichlid Mating Preference}
\format{A data frame with 53 observations on the following 2 variables.
\describe{ \item{genotype}{a factor with levels \code{F1} and
\code{F2}} \item{preference}{a numeric vector} }}
\source{
Haeslery, M.P. and O. Seehausen. 2005. Inheritance of female mating
preference in a sympatric sibling species pair of Lake Victoria cichlids:
implications for speciation. \emph{Proceedings of the Royal Society of
London, Series B, Biological Sciences} 272: 237-245.
}
\description{
Preference index in F1 and F2 crosses of two species of cichlids from Lake
Victoria, \emph{Pundamilia pundamilia} and \emph{P. nyererei}.
}
\examples{
str(Cichlids)

summary(preference ~ genotype, Cichlids, fun = favstats)

if (require(plyr)) {
ddply(Cichlids, .(genotype),
  function(df)c(mean = mean(df$preference),
                standard.deviation = sd(df$preference),
                n = length(df$preference)))
}
}
\references{
\url{http://rspb.royalsocietypublishing.org/content/272/1560/237.full.pdf}
}
\keyword{datasets}

