% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_turmite.R
\name{canvas_turmite}
\alias{canvas_turmite}
\title{Paint a Random Turmite on a Canvas}
\usage{
canvas_turmite(colors, background = '#fafafa', p = 0.5, iterations = 1e7, 
               width = 1500, height = 1500, noise = FALSE)
}
\arguments{
\item{colors}{a character specifying the color used for the artwork. The number of colors determines the number of turmites.}

\item{background}{a character specifying the color used for the background.}

\item{p}{a value specifying the probability of a state switch within the turmite.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{width}{a positive integer specifying the width of the artwork in pixels.}

\item{height}{a positive integer specifying the height of the artwork in pixels.}

\item{noise}{logical. Whether to add k-nn noise to the artwork. Caution, adding noise increases computation time significantly in large dimensions.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints a turmite. A turmite is a Turing machine which has an orientation in addition to a current state and a "tape" that consists of a two-dimensional grid of cells. The algorithm is simple: 1) turn on the spot (left, right, up, down) 2) change the color of the square 3) move forward one square.
}
\examples{
\donttest{
set.seed(17)
palette <- colorPalette('dark2')
canvas_turmite(colors = palette, p = 0, noise = TRUE)
}

}
\references{
\url{https://en.wikipedia.org/wiki/Turmite}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
