% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_forest.R
\name{canvas_forest}
\alias{canvas_forest}
\title{Paint a Random Forest on a Canvas}
\usage{
canvas_forest(colors, n = 1000, resolution = 500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{n}{a positive integer specifying the number of random data points to generate.}

\item{resolution}{a positive integer specifying the number of pixels (resolution x resolution) of the artwork.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function creates an artwork from randomly generated data by running a random forest classification algorithm to predict the color of each pixel on the canvas.
}
\examples{
\donttest{
set.seed(6)
palette <- colorPalette('random', n = 5)
canvas_forest(colors = palette)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
