% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{package}
\name{ZIM-package}
\alias{ZIM}
\alias{ZIM-package}
\title{Zero-Inflated Models for Count Time Series with Excess Zeros}
\description{
Fits observation-driven and parameter-driven models for count time series with excess zeros.
}
\details{
The package \code{ZIM} contains functions to fit statistical models for count time series
with excess zeros (Yang et al., 2013, 2014+). The main function for fitting observation-driven models
is \code{\link{zim}}, and the main function for fitting parameter-driven models is \code{\link{dzim}}.
}
\note{
The observation-driven models for zero-inflated count time series can also be fit using the function
\code{\link[pscl]{zeroinfl}} from the \code{pscl} package (Zeileis et al., 2008).
Fitting parameter-driven models is based on sequential Monte Carlo (SMC) methods, which are
computer intensive and could take several hours to estimate the model parameters.
}
\author{
Ming Yang, Gideon K. D. Zamba, and Joeseph E. Cavanaugh

Maintainer: Ming Yang <mingyang AT hsph.harvard.edu>
}
\references{
Yang, M., Cavanaugh, J. E., and Zamba, G. K. D. (2014+). State-space models for count time series
with excess zeros. \emph{Statistical Modelling}, To Appear. \cr \cr
Yang, M., Zamba, G. K. D., and Cavanaugh, J. E. (2013). Markov regression models for count time series
with excess zeros: A partial likelihood approach. \emph{Statistical Methodology}, \bold{14}:26-38. \cr \cr
Zeileis, A., Kleiber, C., and Jackman, S. (2008). Regression models for count data in \code{R}.
\emph{Journal of Statistical Software}, \bold{27}(8).
}
\keyword{package}

