/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;

public final class ColumnBuilder
extends Common {
    private ArrayList<DataType> detectedTypes;
    private ArrayList<Cell> cells;
    private ArrayList<CellValue> values;
    private String dateTimeFormat;
    private ArrayList<CellValue> isDate = new ArrayList();
    private boolean forceConversion;

    /*
     * WARNING - void declaration
     */
    public ColumnBuilder(int nrows, boolean forceConversion) {
        void var2_2;
        void var1_1;
        this.detectedTypes = new ArrayList(nrows);
        this.cells = new ArrayList(nrows);
        this.values = new ArrayList((int)var1_1);
        this.forceConversion = var2_2;
    }

    public final void addMissing() {
        this.values.add(null);
        this.detectedTypes.add(DataType.Boolean);
    }

    /*
     * WARNING - void declaration
     */
    public final void addValue(Cell c, CellValue cv, DataType dt) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (DataType.DateTime.equals((Object)dt)) {
            this.isDate.add(cv);
        }
        this.cells.add((Cell)var1_1);
        this.values.add((CellValue)var2_2);
        this.detectedTypes.add((DataType)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final DataType determineColumnType() {
        void var1_1;
        DataType columnType = DataType.Boolean;
        Iterator<DataType> it = this.detectedTypes.iterator();
        while (it.hasNext() && !columnType.equals((Object)DataType.String)) {
            void var3_3;
            DataType dt = it.next();
            if (dt.ordinal() <= columnType.ordinal()) continue;
            columnType = var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final ArrayList build(DataType asType) {
        void var2_2;
        DataType columnType;
        columnType = asType == null ? this.determineColumnType() : columnType;
        ArrayList<Object> colValues = new ArrayList<Object>(this.values.size());
        Iterator<CellValue> it = this.values.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            if (cv == null) {
                colValues.add(null);
            } else {
                block2 : switch (columnType) {
                    case Boolean: {
                        switch (this.detectedTypes.get(counter)) {
                            case Boolean: {
                                colValues.add(cv.getBooleanValue());
                                break block2;
                            }
                            case Numeric: {
                                if (this.forceConversion) {
                                    colValues.add(cv.getNumberValue() > 0.0);
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    colValues.add(Boolean.valueOf(cv.getStringValue().toLowerCase()));
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case DateTime: {
                                colValues.add(null);
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from DateTime to Boolean - returning NA");
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case DateTime: {
                        switch (this.detectedTypes.get(counter)) {
                            case Boolean: {
                                colValues.add(null);
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Boolean to DateTime - returning NA");
                                break block2;
                            }
                            case Numeric: {
                                if (this.forceConversion) {
                                    if (DateUtil.isValidExcelDate((double)cv.getNumberValue())) {
                                        colValues.add(DateUtil.getJavaDate((double)cv.getNumberValue()));
                                        break block2;
                                    }
                                    colValues.add(null);
                                    this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Numeric to DateTime - returning NA");
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    try {
                                        colValues.add(Workbook.dateTimeFormatter.parse(cv.getStringValue(), this.dateTimeFormat));
                                    }
                                    catch (Exception exception) {
                                        colValues.add(null);
                                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to DateTime - returning NA");
                                    }
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case DateTime: {
                                colValues.add(DateUtil.getJavaDate((double)cv.getNumberValue()));
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case Numeric: {
                        switch (this.detectedTypes.get(counter)) {
                            case Boolean: {
                                colValues.add(cv.getBooleanValue() ? 1.0 : 0.0);
                                break block2;
                            }
                            case Numeric: {
                                colValues.add(cv.getNumberValue());
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    try {
                                        colValues.add(Double.parseDouble(cv.getStringValue()));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        colValues.add(null);
                                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to Numeric - returning NA");
                                    }
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case DateTime: {
                                if (this.forceConversion) {
                                    colValues.add(cv.getNumberValue());
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case String: {
                        switch (this.detectedTypes.get(counter)) {
                            case Boolean: {
                                colValues.add(Boolean.toString(cv.getBooleanValue()));
                                break block2;
                            }
                            case Numeric: {
                                colValues.add(Double.toString(cv.getNumberValue()));
                                break block2;
                            }
                            case String: {
                                colValues.add(cv.getStringValue());
                                break block2;
                            }
                            case DateTime: {
                                String s = Workbook.dateTimeFormatter.format(DateUtil.getJavaDate((double)cv.getNumberValue()), this.dateTimeFormat);
                                colValues.add(s);
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown column type detected!");
                    }
                }
            }
            ++counter;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDateTimeFormat(String format) {
        void var1_1;
        this.dateTimeFormat = var1_1;
    }
}

