% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xConverter.r
\name{xConverter}
\alias{xConverter}
\title{Function to convert an object between graph classes}
\usage{
xConverter(
obj,
from = c("igraph", "dgCMatrix", "dtree", "lol", "json"),
to = c("dgCMatrix", "igraph", "dtree", "lol", "json", "igraph_tree"),
verbose = TRUE
)
}
\arguments{
\item{obj}{an object of class "igraph", "dgCMatrix", "dtree", "lol",
and "json"}

\item{from}{a character specifying the class converted from. It can be
one of "igraph", "dgCMatrix", "dtree", "lol", "json"}

\item{to}{a character specifying the class converted to. It can be one
of "igraph", "dgCMatrix", "dtree", "lol", "json" and "igraph_tree"}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
an object of class "igraph", "dgCMatrix", "dtree", "lol", or "json".
}
\description{
\code{xConverter} is supposed to convert an object between classes
"igraph", "dgCMatrix", "dtree", "lol", and "json".
}
\note{
Conversion is supported directly: 1) from 'igraph' to
"dgCMatrix","dtree","lol","json","igraph_tree"; 2) from 'dgCMatrix' to
"igraph"; 3) from 'dtree' to "igraph","lol","json"; 4) from 'lol' to
"dtree","json"; 5) from 'json' to "lol","dtree". In summary:
"dgCMatrix" -- "igraph" (hub) -- "dtree" (hub) -- "lol" -- "json".
Note: 1) igraph --as.igraph-- phylo --as.hclust/as.phylo-- hclust
--as.dendrogram/as.hclust-- dendro; 2) igraph --ggraph::den_to_igraph--
dendro
}
\examples{
# generate a ring graph
g <- make_ring(10, directed=TRUE)

# convert the object from 'igraph' to 'dgCMatrix' class
xConverter(g, from='igraph', to='dgCMatrix')

\dontrun{
# Conversion between 'dgCMatrix' and 'igraph'
# ig.EF (an object of class "igraph" storing as a directed graph)
g <- xRDataLoader('ig.EF')
g

# convert the object from 'igraph' to 'dgCMatrix' class
s <- xConverter(g, from='igraph', to='dgCMatrix')
s[1:10,1:10]

# convert the object from 'dgCMatrix' to 'igraph' class
ig <- xConverter(s, from="dgCMatrix", to="igraph")
ig

##############
g <- make_graph("Zachary")

# from 'igraph' to "dtree","lol","json"
dtree <- xConverter(g, from='igraph', to='dtree')
lol <- xConverter(g, from='igraph', to='lol')
json <- xConverter(g, from='igraph', to='json')

# from "lol","json" to 'dtree' 
dtree <- xConverter(lol, from='lol', to='dtree')
dtree <- xConverter(json, from='json', to='dtree')

# from 'dtree' to "igraph"
g <- xConverter(dtree, from='dtree', to='igraph')

# force 'igraph' to a tree
gtree <- xConverter(g, from='igraph', to='igraph_tree')
}
}
\seealso{
\code{\link{xRDataLoader}}
}
