% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGRsampling.r
\name{xGRsampling}
\alias{xGRsampling}
\title{Function to generate random samples for data genomic regions from background genomic regions}
\usage{
xGRsampling(GR.data, GR.background, num.samples = 100, gap.max = 50000,
max.distance = NULL, verbose = T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{GR.data}{an input data GR object, containing a set of genomic
regions based on which to generate a null distribution}

\item{GR.background}{an input background GR object, containing a set of
genomic regions to randomly sample from. It can be a GR list object or
a list of GR objects}

\item{num.samples}{the number of samples randomly generated}

\item{gap.max}{the maximum distance of background islands to be
considered away from data regions. Only background islands no far way
from this distance will be considered. For example, if it is 0, meaning
that only background islands that overlapp with genomic regions will be
considered. By default, it is 50000}

\item{max.distance}{the maximum distance away from data regions that is
allowed when generating random samples. By default, it is NULl meaning
no such restriction}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a list of GR ojects, each containing an GR oject storing a sample.
}
\description{
\code{xGRsampling} is supposed to randomly generate samples for data
genomic regions from background genomic regions. To do so, we first
identify background islands, that is, non-overlapping regions. Then, we
keep only parts of data genomic regions that fall into these background
islands. For each kept genomic region, a randomised region of the same
length is sampled from the corresponding background islands. If
required, the randomised region can be restricted to be no more than
(eg 10000bp) away from data genomic regions.
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"

# Enrichment analysis for GWAS SNPs from ImmunoBase
# a) provide input data GR object storing GWAS SNPs
dbSNP_GWAS <- xRDataLoader(RData.customised='dbSNP_GWAS',
RData.location=RData.location)

# b) provide backgorund data GR object storing FANTOM5 cell-specific enhancers
FANTOM5_Enhancer_Cell <-
xRDataLoader(RData.customised='FANTOM5_Enhancer_Cell',
RData.location=RData.location)

# c) generate random samples as a list of GR objects
sGR_List <- xGRsampling(GR.data=dbSNP_GWAS,
GR.background=FANTOM5_Enhancer_Cell, num.samples=1000,
RData.location=RData.location)
}
}
\seealso{
\code{\link{xGRsampling}}
}
