% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loess_auto.R
\name{loess_auto}
\alias{loess_auto}
\title{Perform an automatically loess based smoothing of a time series}
\usage{
loess_auto(
  time_series = NULL,
  genplot = FALSE,
  print_span = FALSE,
  keep_editable = FALSE
)
}
\arguments{
\item{time_series}{Input is a time series with the first column being depth or time and the second column being a proxy}

\item{genplot}{Option to generate plot \code{Default=TRUE}. \cr
The plot will consist of the original signal in blue, the smoothed plot is displayed
in black and the + and - 1 sd bounds of the smoothing are displayed in red.}

\item{print_span}{Print span length as a fraction of the total length of the record.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
A matrix with 3 columns.
The first column is depth/time.
The second column is the smoothed curve.
The third column is difference between the original curve and the smoothed curve.
}
\description{
Perform an automatically loess based smoothing of a time series.
The local polynomial regression with automatic smoothing parameter selection is based on an
optimization using the 'aicc' bias-corrected 'AIC' criterion and the 'gcv' generalized cross-validation criterion.
}
\examples{
\donttest{
#'smooth the period curve of the 405 kyr eccentricity cycle extracted from
# the magnetic susceptibility data set of Pas et al., (2018)
#perform the CWT on the magnetic susceptibility data set of Pas et al., (2018)

mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

#Track the 405 kyr eccentricity cycle in a wavelet spectra

#mag_track <- track_period_wavelet(astro_cycle = 405,
#                                   wavelet=mag_wt,
#                                   n.levels = 100,
#                                   periodlab = "Period (metres)",
#                                   x_lab = "depth (metres)")

#Instead of tracking, the tracked solution data set mag_track_solution is used
mag_track <- mag_track_solution

mag_track_complete <- completed_series(
  wavelet = mag_wt,
  tracked_curve = mag_track,
  period_up = 1.2,
  period_down = 0.8,
  extrapolate = TRUE,
  genplot = FALSE,
  keep_editable=FALSE
)

#Smooth the completed tracking of the 405 kyr eccentricity cycle as tracked in the wavelet spectra
mag_track_complete <- loess_auto(time_series = mag_track_complete,
genplot = FALSE, print_span = FALSE,keep_editable=FALSE)
}
}
\references{
Cleveland, W. S. (1979) Robust locally weighted regression and smoothing scatter plots. Journal of the American Statistical Association. 74, 829–836. <\doi{doi:10.1080/01621459.1979.10481038}>
Hurvich, C.M., Simonoff, J.S., and Tsai, C.L. (1998), Smoothing Parameter Selection in Nonparametric Regression Using an Improved Akaike Information Criterion. Journal of the Royal Statistical Society B. 60, 271–293 <\doi{doi:10.1111/1467-9868.00125}>
Golub, G., Heath, M. and Wahba, G. (1979). Generalized cross validation as a method for choosing a good ridge parameter. Technometrics. 21, 215–224. <\doi{doi:10.2307/1268518}>
}
\author{
Based on the the \code{\link{loess.as}} function of the 'fANCOVA' R package.
}
