% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{WMWssp_minimize}
\alias{WMWssp_minimize}
\title{Minimizing samplesize for a given Type I and II error rate and prior information x and y}
\usage{
WMWssp_minimize(x, y, alpha = 0.05, power = 0.8, simulation = FALSE,
  nsim = 10^4)
}
\arguments{
\item{x}{a vector of prior information for the first group}

\item{y}{a vector of prior information for the second group}

\item{alpha}{Type I error rate}

\item{power}{Power to detect a relative effect based on the prior information}

\item{simulation}{TRUE if a power simulation should be carried out}

\item{nsim}{number of simulations for the power simulation}
}
\value{
Returns an object from class WMWssp containing

\item{result}{A dataframe with the results.}

\item{t}{The optimal allocation rate for minimizing the sample size.}

\item{alpha}{The type-I error rate which was used.}

\item{power}{The power which was used.}

\item{N}{The minimized sample size.}
}
\description{
This function minimizes the sample size for a given power and type-I error rate with respect to the allocation rate t = n_1/N.
}
\examples{
# Prior information for the reference group
x <- c(315,375,356,374,412,418,445,403,431,410,391,475,379)
# generate data for treatment group based on a shift effect
y <- x - 20

# calculate optimal t
ssp <- WMWssp_minimize(x, y, alpha = 0.05, power = 0.8)
summary(ssp)
}
\references{
Brunner, E., Bathke A. C. and Konietschke, F. Rank- and Pseudo-Rank Procedures in Factorial Designs - Using R and SAS. Springer Verlag. to appear.
}
\keyword{export}
