\name{RVineHessian}        
\alias{RVineHessian}                

\title{Hessian matrix of the log-likelihood of an R-vine copula model}

\description{
This function calculates the Hessian matrix of the log-likelihood of a d-dimensional R-vine copula model with respect to the copula parameter and evaluates it on a given copula data set.
}

\usage{
RVineHessian(data, RVM)
}

\arguments{
  \item{data}{An N x d data matrix (with uniform margins).}
  \item{RVM}{An \code{\link{RVineMatrix}} object including the structure, the pair-copula families, and the parameters.}
}

\note{
The Hessian matrix is not available for R-vine copula models with two parameter Archimedean copulas, i.e. BB1, BB6, BB7, BB8 and their rotated versions.
}

\value{
  \item{hessian}{The calculated Hessian matrix of the log-likelihood value of the R-vine copula model.}
  \item{der}{The product of the gradient vector with its transposed version.}
}


\references{
Schepsmeier, U. and J. Stoeber (2012).
Derivatives and Fisher information of bivariate copulas.
Submitted for publication.
\url{http://mediatum.ub.tum.de/node?id=1106541}.

Stoeber, J. and U. Schepsmeier (2012).
Is there significant time-variation in multivariate dependence?.
In preparation.
\url{http://de.arxiv.org/abs/1205.4841}.

Dissmann, J. F., E. C. Brechmann, C. Czado, and D. Kurowicka (2011).
Selecting and estimating regular vine copulae and application to financial returns.
Submitted for publication.
\url{http://mediatum.ub.tum.de/node?id=1079277}
}

\author{Ulf Schepsmeier, Jakob Stoeber}

\seealso{\code{\link{BiCopDeriv}}, \code{\link{BiCopDeriv2}}, \code{\link{BiCopHfuncDeriv}}, \code{\link{BiCopHfuncDeriv2}}, \cr
\code{\link{RVineMatrix}}, \code{\link{RVineMLE}}, \code{\link{RVineGrad}}}

\examples{
# define 5-dimensional R-vine tree structure matrix
Matrix = c(5,2,3,1,4,0,2,3,4,1,0,0,3,4,1,0,0,0,4,1,0,0,0,0,1)
Matrix = matrix(Matrix,5,5)

# define R-vine pair-copula family matrix
family = c(0,1,3,4,4,0,0,3,4,1,0,0,0,4,1,0,0,0,0,3,0,0,0,0,0)
family = matrix(family,5,5)

# define R-vine pair-copula parameter matrix
par = c(0,0.2,0.9,1.5,3.9,0,0,1.1,1.6,0.9,0,0,0,1.9,0.5,
        0,0,0,0,4.8,0,0,0,0,0)
par = matrix(par,5,5)

# define second R-vine pair-copula parameter matrix
par2 = matrix(0,5,5)

# define RVineMatrix object
RVM = RVineMatrix(Matrix=Matrix,family=family,par=par,par2=par2,
                  names=c("V1","V2","V3","V4","V5"))

# simulate a sample of size 300 from the R-vine copula model
simdata = RVineSim(300,RVM)

# compute the Hessian matrix of the first row of the data
out2 = RVineHessian(simdata[1,],RVM)
out2$hessian

}
