\name{growdotMiss}
\alias{bubbleMiss}
\alias{growdotMiss}
\title{Growing dot map with information about missing/imputed values}
\usage{
  growdotMiss(x, coords, map, pos = 1, delimiter = NULL,
    selection = c("any", "all"), log = FALSE,
    col = c("skyblue", "red", "skyblue4", "red4", "orange", "orange4"),
    border = par("bg"), alpha = NULL, scale = NULL,
    size = NULL, exp = c(0, 0.95, 0.05),
    col.map = grey(0.5), legend = TRUE,
    legtitle = "Legend", cex.legtitle = par("cex"),
    cex.legtext = par("cex"), ncircles = 6, ndigits = 1,
    interactive = TRUE, ...)
}
\arguments{
  \item{x}{a vector, matrix or \code{data.frame}.}

  \item{coords}{a matrix or \code{data.frame} with two
  columns giving the spatial coordinates of the
  observations.}

  \item{map}{a background map to be passed to
  \code{\link{bgmap}}.}

  \item{pos}{a numeric value giving the index of the
  variable determining the dot sizes.}

  \item{delimiter}{a character-vector to distinguish
  between variables and imputation-indices for imputed
  variables (therefore, \code{x} needs to have
  \code{\link{colnames}}). If given, it is used to
  determine the corresponding imputation-index for any
  imputed variable (a logical-vector indicating which
  values of the variable have been imputed). If such
  imputation-indices are found, they are used for
  highlighting and the colors are adjusted according to the
  given colors for imputed variables (see \code{col}).}

  \item{selection}{the selection method for highlighting
  missing/imputed values in multiple additional variables.
  Possible values are \code{"any"} (highlighting of
  missing/imputed values in \emph{any} of the additional
  variables) and \code{"all"} (highlighting of
  missing/imputed values in \emph{all} of the additional
  variables).}

  \item{log}{a logical indicating whether the variable
  given by \code{pos} should be log-transformed.}

  \item{col}{a vector of length six giving the colors to be
  used in the plot. If only one color is supplied, it is
  used for the borders of non-highlighted dots and the
  surface area of highlighted dots.  Else if two colors are
  supplied, they are recycled.}

  \item{border}{a vector of length four giving the colors
  to be used for the borders of the growing dots.  Use
  \code{NA} to omit borders.}

  \item{alpha}{a numeric value between 0 and 1 giving the
  level of transparency of the colors, or \code{NULL}.
  This can be used to prevent overplotting.}

  \item{scale}{scaling factor of the map.}

  \item{size}{a vector of length two giving the sizes for
  the smallest and largest dots.}

  \item{exp}{a vector of length three giving the factors
  that define the shape of the exponential function (see
  \sQuote{Details}).}

  \item{col.map}{the color to be used for the background
  map.}

  \item{legend}{a logical indicating whether a legend
  should be plotted.}

  \item{legtitle}{the title for the legend.}

  \item{cex.legtitle}{the character expansion factor to be
  used for the title of the legend.}

  \item{cex.legtext}{the character expansion factor to be
  used in the legend.}

  \item{ncircles}{the number of circles displayed in the
  legend.}

  \item{ndigits}{the number of digits displayed in the
  legend.  Note that \ this is just a suggestion (see
  \code{\link{format}}).}

  \item{interactive}{a logical indicating whether
  information about certain observations can be displayed
  interactively (see \sQuote{Details}).}

  \item{\dots}{for \code{growdotMiss}, further arguments
  and graphical parameters to be passed to
  \code{\link{bgmap}}.  For \code{bubbleMiss}, the
  arguments to be passed to \code{growdotMiss}.}
}
\description{
  Map with dots whose sizes correspond to the values in a
  certain variable. Observations with missing/imputed
  values in additional variables are highlighted.
}
\details{
  The smallest dots correspond to the 10\% quantile and the
  largest dots to the 99\% quantile.  In between, the dots
  grow exponentially, with \code{exp} defining the shape of
  the exponential function.  Missings/imputed missings in
  the variable of interest will be drawn as rectangles.

  If \code{interactive=TRUE}, detailed information for an
  observation can be printed on the console by clicking on
  the corresponding point.  Clicking in a region that does
  not contain any points quits the interactive session.
}
\note{
  The function was renamed to \code{growdotMiss} in version
  1.3. \code{bubbleMiss} is a (deprecated) wrapper for
  \code{growdotMiss} for back compatibility with older
  versions. However, due to extended functionality, some of
  the argument positions have changed.

  The code is based on \code{\link[StatDA]{bubbleFIN}} from
  package \code{StatDA}.
}
\examples{
data(chorizonDL, package = "VIM")
data(kola.background, package = "VIM")
coo <- chorizonDL[, c("XCOO", "YCOO")]
## for missing values
x <- chorizonDL[, c("Ca","As", "Bi")]
growdotMiss(x, coo, kola.background, border = "white")

## for imputed values
x_imp <- kNN(chorizonDL[,c("Ca","As","Bi" )])
growdotMiss(x_imp, coo, kola.background, delimiter = "_imp", border = "white")
}
\author{
  Andreas Alfons, Matthias Templ, Peter Filzmoser, Bernd
  Prantner
}
\references{
  M. Templ, A. Alfons, P. Filzmoser (2012) Exploring
  incomplete data using visualization tools.  \emph{Journal
  of Advances in Data Analysis and Classification}, Online
  first. DOI: 10.1007/s11634-011-0102-y.
}
\seealso{
  \code{\link{bgmap}}, \code{\link{mapMiss}},
  \code{\link{colormapMiss}}
}
\keyword{hplot}

