% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{Sinv}
\alias{Sinv}
\title{Calling C-implementation of the SWEEP-Operator for Matrix-Inversion}
\usage{
Sinv(M, tol = .Machine$double.eps)
}
\arguments{
\item{M}{(matrix) matrix, representing the augmented matrix \eqn{X'X}}

\item{tol}{(numeric) value used to check numerical equivalence to zero}
}
\value{
(Matrix) object corresponding to the inverted matrix
}
\description{
Function calls a fast C-implementation of the SWEEP operator using the
transpose of the matrix to be swept for generating a generalized inverse of 
a matrix for which no regular matrix invers exists.
}
\details{
Transposing prior to applying the SWEEP-operator speeds up things since the 
complete matrix is stored in memory in consecutive manner. 
This version of the SWEEP-operator is intended for matrix inversion only, thus,
not computing ANOVA sum of squares and number of linear dependencies (see function
\code{\link{Csweep}}).

This is an utility-function not intended to be called directly.
}
\examples{
\dontrun{
M <- matrix(c(4,-6,6,-9),2)
solve(m)			# regular inverse does not exist
Mi1 <- MPinv(M)			# MASS-implementation 'ginv'
Mi1
M \%*\% Mi1 \%*\% M			# should be M
Mi2 <- VCA:::Sinv(M)
Mi2
M \%*\% Mi2 \%*\% M			# should be M
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}

