% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roots_sh.R
\name{roots_sh}
\alias{roots_sh}
\title{Eigenvalues of the companion coefficient matrix of
a VAR(p)-process}
\usage{
roots_sh(x, modulus = TRUE)
}
\arguments{
\item{x}{An object of class "varshrinkest"}

\item{modulus}{TRUE for modulus of the roots.}
}
\description{
This is a variant of vars::roots() for an object of class 'varshrinkest',
VAR parameters estimated by \code{VARshrink()}.
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
roots_sh(estim)
}
\seealso{
\code{\link[vars]{roots}}
}
