% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causality_sh.R
\name{causality_sh}
\alias{causality_sh}
\title{Causality Analysis for class "varshrinkest"}
\usage{
causality_sh(x, cause = NULL, vcov. = NULL, boot = FALSE,
  boot.runs = 100)
}
\arguments{
\item{x}{An object of class "varshrinkest" obtained by VARshrink().}

\item{cause, vcov., boot, boot.runs}{Other arguments for
causality analysis; see help(causality) for details.}
}
\description{
A modification of vars::causality() for the class "varshrinkest".
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
causality_sh(estim, cause = "e")
}
\seealso{
\code{\link[vars]{causality}}
}
