% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_merge.R
\name{var_merge}
\alias{var_merge}
\title{Solve the variational problem by the finite element method.}
\usage{
var_merge(coordinates, elements, uhat, v, eta_0)
}
\arguments{
\item{coordinates}{A data frame with Node definitions in relative coordinates.}

\item{elements}{A data frame containing element definitions and nodes should be ordered counterclockwise.}

\item{uhat}{A matrix containing values from the interpolated image with x  y and data and the next column structure

x y date1 date2 date3}

\item{v}{A matrix containing values from the satellite/model based image.

The values of uhat and v should correspond to the same pixels in the coordinates matrix.}

\item{eta_0}{A scalar representing length scale constant.}
}
\value{
A data frame representing resulting images in relative coordinates.
}
\description{
It takes as input the coordinates of the nodes (variable coordinates defined in the mesh_3 function).
The table of elements (variable elements defined in the mesh_3 function).
The fields uhat and v, and the factor eta_0

Note that columns of uhat and v are arranged as follows:

date1 date2 date3

And performs the variational merging technique to uhat and v using the finite.

uhat and v have to be introduced like in the example, only with data
}
\examples{
\donttest{
data(uhat,"VARMER")
invisible(force(uhat))
data(v,"VARMER")
invisible(force(v))
data(coordinates,"VARMER")
invisible(force(coordinates))
data(elements,"VARMER")
invisible(force(elements))
eta_0=0.5
U=var_merge(coordinates, elements, uhat[,3:ncol(uhat)], v[,3:ncol(v)], eta_0)
}
}
