% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UMRactiveSet_trust.R
\name{UMRactiveSet_trust}
\alias{UMRactiveSet_trust}
\title{An active set approach to minimizing objective in Unlinked Monotone
    Regression}
\usage{
UMRactiveSet_trust(
  yy,
  ww_y = NULL,
  grad,
  hess,
  UMR_curv,
  CDF,
  init,
  counts = rep(1, length(init)),
  stepsize,
  MM,
  tol_end = 1e-04,
  tol_collapse,
  printevery,
  filename
)
}
\arguments{
\item{yy}{Y (response) observation vector (numeric)}

\item{ww_y}{Weights (nonnegative,  sum to  1) corresponding to  yy.  Samelength as yy.  Or NULL in which yy are taken as being evenly weighted.}

\item{grad}{Is function(mm, ww_m).  (Will be defined based on yy [and maybe ww_y] before being passed in.)  Returns vector of length(mm).  Gradient of objective function.}

\item{hess}{Is function(mm, ww_m). (Will be defined based on yy [and maybe ww_y] before being passed in.)  Returns matrix of dimensions length(mm) by length(mm).  Hessian of objective function.}

\item{UMR_curv}{A curvature function object (giving mathfrak(C) in the paper; and related to "C" in the paper).   See UMR_curv_generic() and examples.  This is generally a "curried" version of UMR_curv_generic with densfunc and BBp passed in.}

\item{CDF}{This is the error (cumulative) distribution function, a  function object.  Function accepting vector or matrix arguments.}

\item{init}{Initial value of estimate ('mm').  Vector, length may be different than length(yy). See 'counts' input.}

\item{counts}{Together 'init' and 'counts' serve as the initialization; the implied initial vector is rep.int(init, counts).}

\item{stepsize}{Stepsize for moving out of saddle points.}

\item{MM}{A number  of iterations.   May not  use them  all.  MM  is not
exactly the total  number of iterations used in the  sense that within
each of  MM iterations, we  will possibly run another  algorithm which
may take up to MM iterations (but usually takes many fewer).}

\item{tol_end}{Used as tolerance at various points .  Generally algorithm (and
some subalgorithms) end once sum(abs(mm-mmprev))  < tol, or you hit MM
iterations.}

\item{tol_collapse}{Collapsing roughly equal mm values into each other.}

\item{printevery}{integer  value (generally  << MM).   Every 'printevery'
iterations, a count will be printed and the output saved.}

\item{filename}{filename (path) to save output to.}
}
\description{
An active set approach to minimizing objective in Unlinked Monotone
    Regression
}
\details{
Uses first order  (gradient) for optimization, and  uses certain
    second   derivative  computations   to  leave   saddle  points.    See
    Balabdaoui, Doss, and Durot (2021).  Note that yy and mm (i.e., number
    covariates) may have different length.
}
