library(testthat)

###### AMSP ######
testthat::test_that("Check that the AMSP results are correct for gauge 30013", {
  expected_output <- data.frame(
    Date = as.Date(c(
      "1977-02-13", "1978-02-07", "1978-12-31", "1980-02-10", "1981-03-13",
      "1982-01-05", "1983-05-08", "1984-02-04", "1985-01-29", "1986-01-14",
      "1987-04-10", "1988-02-01", "1989-04-13", "1990-02-13", "1991-07-13",
      "1992-01-08", "1993-01-13", "1993-10-15", "1995-01-31", "1995-12-22",
      "1997-08-31", "1998-01-05", "1999-03-13", "2000-04-26", "2000-11-11",
      "2002-08-09", "2003-01-01", "2004-08-13", "2005-07-14", "2006-08-17",
      "2007-06-25", "2008-01-21", "2008-11-09", "2010-03-01", "2011-07-21",
      "2012-07-18", "2012-12-24", "2014-02-01", "2015-08-14", "2016-03-09",
      "2016-11-21", "2018-06-02", "2019-06-13", "2019-11-11", "2021-07-30",
      "2022-08-16", "2022-11-24"
    )),
    Flow = c(
      1.220, 0.751, 0.917, 0.889, 0.911, 0.694, 0.604, 0.872, 0.473, 0.412,
      0.929, 0.653, 0.226, 0.330, 0.314, 0.341, 0.541, 0.633, 0.751, 0.223,
      0.334, 1.195, 0.699, 0.464, 0.998, 0.828, 1.052, 0.518, 0.486, 0.276,
      5.337, 0.923, 0.504, 0.653, 0.420, 1.695, 1.259, 0.623, 0.395, 0.509,
      0.395, 1.351, 0.608, 2.055, 1.214, 0.643, 0.513
    )
  )

  AMSP <- AMSP

  actual_output <- AMSP[AMSP$id == "30013", 1:2]

  testthat::expect_equal(expected_output$Date, actual_output$Date)

  testthat::expect_equal(expected_output$Flow, actual_output$Flow)
})

testthat::test_that("Check that the AMSP results are correct for gauge 28049", {
  expected_output <- data.frame(
    Date = as.Date(c(
      "1971-04-25", "1972-02-04", "1973-07-17", "1974-02-12", "1974-11-21",
      "1976-09-25", "1977-02-25", "1978-02-04", "1979-04-08", "1980-03-19",
      "1981-04-27", "1982-06-23", "1983-05-02", "1984-03-24", "1985-04-12",
      "1986-05-20", "1987-04-08", "1987-10-21", "1989-04-05", "1990-01-28",
      "1990-10-18", "1992-09-26", "1993-06-11", "1993-10-07", "1995-01-28",
      "1996-02-13", "1996-12-20", "1998-06-02", "1998-10-27", "2000-04-04",
      "2000-11-07", "2001-10-26", "2002-12-30", "2004-08-24", "2004-10-21",
      "2005-11-09", "2007-06-26", "2008-01-21", "2009-06-11", "2010-01-16",
      "2011-02-26", "2012-04-30", "2012-11-25", "2014-02-11", "2015-01-01",
      "2016-03-28", "2016-11-22", "2018-04-02", "2019-09-29", "2019-11-08",
      "2021-02-07", "2022-08-16", "2022-11-18"
    )),
    Flow = c(
      7.330, 5.040, 8.760, 2.530, 3.110, 0.769, 9.510, 2.680, 9.670, 9.350,
      7.890, 10.700, 11.200, 5.600, 6.540, 8.690, 9.630, 5.880, 3.660, 6.100,
      2.970, 2.050, 2.590, 6.200, 5.310, 1.810, 5.450, 4.610, 4.240, 5.370,
      10.400, 3.610, 6.260, 4.390, 2.390, 2.870, 17.200, 5.490, 9.160, 5.160,
      2.530, 6.950, 9.830, 3.640, 2.920, 5.200, 6.190, 8.850, 5.668, 16.927,
      8.722, 7.816, 9.380
    )
  )

  AMSP <- AMSP

  actual_output <- AMSP[AMSP$id == "28049", 1:2]

  testthat::expect_equal(expected_output$Date, actual_output$Date)

  testthat::expect_equal(expected_output$Flow, actual_output$Flow)
})

testthat::test_that("Check that the AMSP results are correct for gauge 54906", {
  expected_output <- expected_output <- data.frame(
    Date = as.Date(
      c(
        "1953-04-03", "1954-08-20", "1955-03-27", "1956-01-26",
        "1956-12-29", "1957-11-05", "1959-01-22", "1960-01-25",
        "1960-12-04", "1962-08-17", "1962-12-20", "1963-11-19",
        "1965-09-09", "1965-12-19", "1967-05-15", "1968-01-14",
        "1969-05-06", "1970-08-21", "1971-01-24", "1972-09-09",
        "1972-12-07", "1974-02-15", "1974-11-21", "1976-09-26",
        "1977-06-14", "1978-01-28", "1979-02-02", "1979-12-28",
        "1981-03-11", "1981-12-31", "1983-04-21", "1983-12-20",
        "1985-04-08", "1987-06-19", "1988-01-24", "1989-02-24",
        "1990-02-07", "1991-01-10", "1992-05-29", "1992-10-02"
      ),
      format = "%Y-%m-%d"
    ),
    Flow = c(
      11.716, 11.412, 52.200, 10.081, 14.747, 16.793, 17.143, 48.987, 21.552,
      12.645, 8.951, 10.518, 14.581, 20.415, 16.100, 21.552, 20.415, 31.600,
      14.252, 13.925, 17.496, 10.010, 10.100, 19.400, 18.517, 15.864, 20.959,
      24.143, 17.449, 45.455, 16.897, 15.732, 16.806, 20.156, 22.870, 19.597,
      21.399, 16.090, 19.673, 52.086
    )
  )

  AMSP <- AMSP

  actual_output <- AMSP[AMSP$id == "54906", 1:2]

  testthat::expect_equal(expected_output$Date, actual_output$Date)

  testthat::expect_equal(expected_output$Flow, actual_output$Flow)
})
