% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GH2z.R
\name{GH2z}
\alias{GH2z}
\title{Inverse of Tukey \eqn{g}-&-\eqn{h} Transformation}
\usage{
GH2z(q, q0 = (q - A)/B, A = 0, B = 1, ...)
}
\arguments{
\item{q}{\link[base]{double} \link[base]{vector}, quantiles \eqn{q}}

\item{q0}{(optional) \link[base]{double} \link[base]{vector},
standardized quantiles \eqn{q_0=(q-A)/B}}

\item{A, B}{(optional) \link[base]{double} \emph{scalars}, location and scale parameters of
Tukey \eqn{g}-&-\eqn{h} trasformation.  Ignored if \code{q0} is provided.}

\item{...}{parameters of internal helper function \link{.GH2z}}
}
\value{
Function \link{GH2z} returns a \link[base]{double} \link[base]{vector} of the same length as input \code{q}.
}
\description{
To transform Tukey \eqn{g}-&-\eqn{h} quantiles to standard normal quantiles.
}
\details{
Unfortunately, function \link{GH2z}, the inverse of Tukey \eqn{g}-&-\eqn{h} transformation,
does not have a closed form and needs to be solved numerically.

For compute intensive jobs, use internal helper function \link{.GH2z}.
}
\examples{
z = rnorm(1e3L)
all.equal.numeric(.GH2z(z2GH(z, g = .3, h = .1), g = .3, h = .1), z)
all.equal.numeric(.GH2z(z2GH(z, g = 0, h = .1), g = 0, h = .1), z)
all.equal.numeric(.GH2z(z2GH(z, g = .2, h = 0), g = .2, h = 0), z)

}
