% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadiationPartitioningFunctions.R
\name{proportion_diffuse_solar_radiation}
\alias{proportion_diffuse_solar_radiation}
\title{Ratio of Diffuse to Direct Solar Radiation}
\usage{
proportion_diffuse_solar_radiation(psi, p_a, A)
}
\arguments{
\item{psi}{\code{numeric} Zenith angle of the sun (degrees).}

\item{p_a}{\code{numeric} Atmospheric pressure (kPa).}

\item{A}{\code{numeric} albedo of the substrate (fraction of 1).}
}
\value{
\code{numeric} diffuse fraction.
}
\description{
The function estimates the ratio of diffuse to direct solar radiation based on the approximation of the SOLRAD model \insertCite{McCullough1971}{TrenchR} described in \insertCite{Tracy1983;textual}{TrenchR}.
}
\examples{
  proportion_diffuse_solar_radiation(psi = 60, 
                                     p_a = 86.1, 
                                     A   = 0.25)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
