% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTRFunctions.R
\name{diurnal_temp_variation_sine}
\alias{diurnal_temp_variation_sine}
\title{Hourly Temperature Variation assuming a Sine Interpolation}
\usage{
diurnal_temp_variation_sine(T_max, T_min, t)
}
\arguments{
\item{T_max, T_min}{\code{numeric} maximum and minimum daily temperatures (C).}

\item{t}{\code{numeric} time for temperature estimate (hour).}
}
\value{
\code{numeric} temperature (C) at a specified hour.
}
\description{
The function estimates temperature for a specified hour using the sine interpolation in \insertCite{Campbell1998;textual}{TrenchR}.
}
\examples{
  diurnal_temp_variation_sine(T_max = 30, 
                              T_min = 10, 
                              t     = 11)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
