% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_display.R
\name{ConsensusWithout}
\alias{ConsensusWithout}
\alias{MarkMissing}
\title{Consensus without taxa}
\usage{
ConsensusWithout(trees, tip, ...)

MarkMissing(tip, position = "bottomleft", ...)
}
\arguments{
\item{trees}{A list of phylogenetic trees, of class \code{multiPhylo} or \code{list}.}

\item{tip}{A character vector specifying the names (or numbers) of tips to
drop (using ape::drop.tip).}

\item{\dots}{Additional parameters to pass on to \link[ape:consensus]{ape::consensus} or \link{legend}.}

\item{position}{Where to plot the missing taxa.  See \link{legend} for options.}
}
\value{
\code{ConsensusWithout} returns a consensus tree (of class \code{phylo})
without the excluded taxa.
}
\description{
Displays a consensus plot with selected taxa excluded.
}
\details{
A useful way to gain resolution if a few wildcard taxa obscure a consistent
set of relationship.
}
\section{Functions}{
\itemize{
\item \code{MarkMissing}: Adds labels for taxa omitted from a plotted
consensus tree.
}}

\examples{
oldPar <- par(mfrow=c(1, 2), mar=rep(0.5, 4))

# Two trees differing only in placement of tip 2:
trees <- as.phylo(c(0, 53), 6)
plot(trees[[1]])
plot(trees[[2]])

# Strict consensus lacks resolution:
plot(ape::consensus(trees))

# But omitting tip two reveals shared structure in common:
plot(ConsensusWithout(trees, 't2'))
MarkMissing('t2')

par(oldPar)

}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})

Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
