% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{readTLS}
\alias{readTLS}
\title{Import a point cloud file into a LAS object}
\usage{
readTLS(file, col_names = NULL, ...)
}
\arguments{
\item{file}{file path.}

\item{col_names}{optional - \code{character} vector. Only used for table-like objects. It states the column names. If not set, only the 3 first columns will be used and assigned to the XYZ fields.}

\item{...}{further arguments passed down to \code{readLAS}, \code{read.las} or \code{fread}.}
}
\value{
\code{\link[lidR:LAS]{LAS}} object.
}
\description{
Wrapper to read point cloud files straight into LAS objects. Reads \emph{las} or \emph{laz} files with \code{\link[lidR:readLAS]{readLAS}}, \emph{ply} files with \code{\link[rlas:read.las]{read.las}} and other file formats with \code{\link[data.table:fread]{fread}} (txt, xyz, 3d or any other table like format).
}
\examples{
cloud = matrix(runif(300), ncol=3)
file = tempfile(fileext = '.txt')
fwrite(cloud, file)
tls = readTLS(file)
summary(tls)
}
