% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.trtsel.R
\name{evaluate.trtsel}
\alias{evaluate.trtsel}
\alias{evaluate}
\title{evaluate the performance of one or more biomarkers for their ability to guide patient treatment recommendations.}
\usage{
\method{evaluate}{trtsel}(x, ..., bias.correct = TRUE, bootstraps = 1000,
  alpha = 0.05)
}
\arguments{
\item{x}{An object of class "trtsel", created by using the function "trtsel."}

\item{...}{ignored.}

\item{bias.correct}{logical indicator of whether to bias-correct measures for over-optimism using bootstrap-bias correction. When the same data is used to fit and evaluate the model, performance measures are over-optimistic. Setting this equal to TRUE uses a bootstrap method to bias-correct performance measures. See details for more information.}

\item{bootstraps}{Number of bootstrap replicates for creating confidence intervals for each performance measure. The default value is 1000. Set bootstraps = 0 if no confidence intervals are desired.}

\item{alpha}{(1-alpha)*100\% confidence intervals are calculated. Default value is alpha = 0.05 which yields 95\% CI's.  The same alpha is used for the two-sided type-I error for the test of H0: No decrease in event rate under marker-based treatment.}
}
\value{
A list with the following components (see Janes et al. (2013) for a description of the summary measures and estimators): 
\item{test.Null }{ List of results of a test of the null hypothesis H0: No decrease in event rate under marker-based treatment. Contains "reject" (logical; was H0 rejected), p.value, z.statistic, and alpha }
\item{estimates }{data.frame of dimension 1x9 of summary measure estimates. Includes:
   p.rec.trt : proportion recommended treatment;
 p.rec.notrt : proportion recommended no treatment;
 B.neg.emp, B.neg.mod: Average benefit of no treatment among those recommended no trt, empirical and model-based estimates;
 B.pos.emp, B.neg.mod: Average benefit of treatment among those recommended trt, empirical and model-based estimates;
 Theta.emp, Theta.mod: Decrease in rate of outcomes under marker-based treatment, empirical and model-based estimates; 
 Var.Delta: variance in estimated treatment effect; 
 TG: Total gain.  
 ER.trt0.emp/mod, ER.trt1.emp/mod, ER.mkrbased.emp/mod: Event rates under trt = 0, trt = 1 or for marker-based treatment. 
 Marker.Thresh: Marker positivity threshold-- defined as the maximum marker value such that estimated treatment effect < "thresh" (=treatment effect used to define the treatment rule, this is set when creating the trtsel object). If all observations are marker negative (or all are positive), Marker.Thresh has value NA}
\item{conf.intervals}{ data.frame of dimension 2x9 with bootstrap-based confidence intervals for each summary measures. If bootstraps = 0 or boot = FALSE, this component is NULL. }
}
\description{
Evaluates the ability of one or more biomarkers for their ability to guide patient treatment recommendations.  
  (Bias-corrected) summary measures of marker performance are estimated and confidence intervals are provided.  
  This function accepts as input an object of class "trtsel", created using the function "trtsel".
}
\note{
The evaluate function used this way both fit and evaluates a risk model using the same data, which is known to bias performance measure estimates to be overly optimistic. To correct for this bias, the evaluate function by default sets bias.correct=TRUE. This implements bootstrap bias correction via the ``refined bootstrap" method described in Efron and Tibshirani 1994. In short, we sample BB bootstrap datasets. For each, obtain a new treatment selection rule based on the re-fit model and calculate the difference in estimated performance of this rule using the bootstrap vs. original data. The average of these differences estimates the bias. We shift naive performance estimates and confidence intervals down by the estimated bias.
}
\examples{
data(tsdata)

###########################
## Create trtsel objects 
###########################

trtsel.Y1 <- trtsel(event ~ Y1*trt, 
                   treatment.name = "trt", 
                   data = tsdata, 
                   study.design = "RCT",
                   link = "logit", 
                   default.trt = "trt all")
trtsel.Y1

#################################
## Evaluate marker performance
#################################

# Marker Y1
estimates.Y1 <- evaluate(trtsel.Y1, bootstraps = 50)
estimates.Y1

}
\seealso{
\code{\link{trtsel}} for creating trtsel objects, \code{\link{plot.trtsel}} for plotting risk curves and more, \code{\link{calibrate.trtsel}} for assessing model calibration, and \code{\link{compare.trtsel}} to compare two trtsel object.
}
