% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HighlightByNode.R
\name{highlight_by_node}
\alias{highlight_by_node}
\title{Highlight Nodes in a Phylogenetic Tree with Custom Fill Colors and Transparency}
\usage{
highlight_by_node(
  ggtree_object,
  nodes,
  fill_colors,
  alpha_values,
  extend_values
)
}
\arguments{
\item{ggtree_object}{A `ggtree` object representing the phylogenetic tree.}

\item{nodes}{A character vector specifying the nodes to highlight.}

\item{fill_colors}{A character vector specifying the fill colors for the highlighted nodes.}

\item{alpha_values}{A numeric vector specifying the transparency values for the highlighted nodes (between 0 and 1).}

\item{extend_values}{A logical vector specifying whether to extend the highlight to the whole clade below each node.}
}
\value{
A modified `ggtree` object with the specified nodes highlighted.
}
\description{
This function adds highlights to specific nodes in a phylogenetic tree represented by a `ggtree` object.
Users can specify the nodes to highlight along with custom fill colors, transparency, and extension options.
}
\examples{
plot_file <- system.file("extdata", "tree_plot.rds", package = "TransProR")
p2_plot <- readRDS(plot_file)

# Please replace the following vectors with your specific values
nodes <- c(117, 129, 125, 127, 119,
           123, 139, 166, 124, 131, 217) # x-values of the nodes you want to highlight
fill_colors <- c("#CD6600", "#CD6600", "#CD6600",
                 "#CD6600", "#009933", "#009933",
                 "#009933", "#009933", "#9B30FF",
                 "#9B30FF", "#9B30FF") # Fill colors
alpha_values <- c(0.3, 0.3, 0.3, 0.3, 0.2, 0.3,
                  0.3, 0.3, 0.3, 0.3, 0.3) # Transparency values
extend_values <- c(25, 24, 24, 25, 25, 25,
                   24, 24, 25, 24, 24) # Values for the 'extend' parameter

p2 <- highlight_by_node(
  p2_plot,
  nodes,
  fill_colors,
  alpha_values,
  extend_values
)
}
