% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitDF.R
\name{splitDF}
\alias{splitDF}
\title{Split \link[base]{data.frame} by Row}
\usage{
splitDF(x)
}
\arguments{
\item{x}{\link[base]{data.frame}}
}
\value{
Function \link{splitDF} returns a \link[base]{list} of \link[base]{nrow}-1 \link[base]{data.frame}s.
}
\description{
\link[base]{split.data.frame} into individual rows.
}
\note{
We use \link[base]{split.data.frame} with argument \code{f} being \code{attr(x, which = 'row.names', exact = TRUE)} instead of
\code{seq_len(.row_names_info(x, type = 2L))},
not only because the former is faster, but also \link[base]{.rowNamesDF<-} enforces
that \link[base]{row.names.data.frame} must be unique.
}
\examples{
splitDF(head(mtcars)) # data.frame with rownames
splitDF(head(warpbreaks)) # data.frame without rownames
splitDF(data.frame()) # exception
}
